/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.array.ArrayUtil;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.INamespaceContext;
import electric.xml.IXPath;
import electric.xml.IXPathFactory;
import electric.xml.Node;
import electric.xml.Nodes;
import electric.xml.Parent;
import electric.xml.XPathException;
import electric.xml.xpath.TMEXPathFactory;

public final class XPath
implements IXPath {
    private static IXPathFactory[] factories = new IXPathFactory[0];
    private static IXPathFactory defaultFactory = new TMEXPathFactory();
    private static boolean cacheByDefault = true;
    private IXPath xpath;

    public XPath(String xpath) throws XPathException {
        this(xpath, null, cacheByDefault);
    }

    public XPath(String xpath, boolean cache) throws XPathException {
        this(xpath, null, cache);
    }

    public XPath(String xpath, INamespaceContext namespaceContext) throws XPathException {
        this(xpath, namespaceContext, cacheByDefault);
    }

    public XPath(String xpath, INamespaceContext namespaceContext, boolean cache) throws XPathException {
        this.xpath = cache ? defaultFactory.newCachedXPath(xpath, namespaceContext) : defaultFactory.newXPath(xpath, namespaceContext);
    }

    public String toString() {
        return this.xpath.toString();
    }

    public static IXPathFactory getFactory() {
        return defaultFactory;
    }

    public static synchronized void setFactory(IXPathFactory factory) {
        defaultFactory = factory;
        int i = 0;
        while (i < factories.length) {
            if (factories[i] == factory) {
                return;
            }
            ++i;
        }
        XPath.addFactory(factory);
    }

    public static synchronized void addFactory(IXPathFactory factory) {
        factories = (IXPathFactory[])ArrayUtil.addElement(factories, factory);
    }

    public static synchronized IXPathFactory getFactory(int implementationLevel) {
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getImplementationLevel() == implementationLevel) {
                return factories[i];
            }
            ++i;
        }
        return null;
    }

    public static void setCacheByDefault(boolean flag) {
        cacheByDefault = flag;
    }

    public static boolean getCacheByDefault() {
        return cacheByDefault;
    }

    public Nodes getNodes(Node node) throws XPathException {
        return this.xpath.getNodes(node);
    }

    public Node getNode(Node node) throws XPathException {
        return this.xpath.getNode(node);
    }

    public Attribute getAttribute(Element element) throws XPathException {
        return this.xpath.getAttribute(element);
    }

    public Attributes getAttributes(Element element) throws XPathException {
        return this.xpath.getAttributes(element);
    }

    public Element getElement(Parent parent) throws XPathException {
        return this.xpath.getElement(parent);
    }

    public Elements getElements(Parent parent) throws XPathException {
        return this.xpath.getElements(parent);
    }

    public void setNamespace(String prefix, String namespace) throws XPathException {
        this.xpath.setNamespace(prefix, namespace);
    }

    public boolean getBoolean(Node node) {
        return this.xpath.getBoolean(node);
    }
}

