/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.path.PathUtil;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.config.IEXMLConfigConstants;
import electric.xml.io.Mapping;
import electric.xml.io.Namespaces;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.MapFile;
import electric.xml.io.mapping.MapFileLoader;
import electric.xml.io.mapping.MapFileParser;
import electric.xml.io.model.All;
import electric.xml.io.schema.EncodingMismatchException;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Mappings
implements ILoaderConstants,
IEXMLLoggingConstants,
IEXMLConfigConstants,
ISchemaConstants {
    private static Mapping[] mappings = new Mapping[0];
    private static final Hashtable namespaceToPackage = new Hashtable();
    private static final Hashtable packageToNamespace = new Hashtable();
    private static final MapFileParser mapFileParser = new MapFileParser();
    private static final MapFileLoader mapFileLoader = new MapFileLoader();
    private static final Vector mapFilePaths = new Vector();
    private static String namespacePrefix;
    private static String defaultPackage;
    private static boolean started;
    private static String[] encodingStyles;
    private static Hashtable encodingToNamespaces;
    private static Namespaces defaultNamespaces;

    public static Namespaces getNamespacesForEncoding(String encodingStyle) {
        if (encodingStyle == null) {
            return defaultNamespaces;
        }
        Namespaces namespaces = (Namespaces)encodingToNamespaces.get(encodingStyle);
        if (namespaces == null) {
            namespaces = defaultNamespaces;
        }
        return namespaces;
    }

    public static boolean isMappingNamespaces(Namespaces namespaces) {
        if (namespaces == null) {
            return false;
        }
        if (namespaces.equals(defaultNamespaces)) {
            return true;
        }
        Enumeration namespacesEnumeration = encodingToNamespaces.elements();
        while (namespacesEnumeration.hasMoreElements()) {
            if (!namespaces.equals(namespacesEnumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public static synchronized void startup() throws ParseException, IOException {
        if (started) {
            return;
        }
        started = true;
        Mappings.setNamespaces();
        namespacePrefix = SchemaProperties.getTmePackage();
        Mappings.readMappings();
    }

    private static void setNamespaces() {
        defaultNamespaces = new Namespaces();
        Product.startup();
        defaultNamespaces.setVersion(SchemaProperties.getDefaultSchema());
        defaultNamespaces.initialize();
        int i = 0;
        while (i < encodingStyles.length) {
            Namespaces encodingStyleNamespaces = new Namespaces(SchemaProperties.getDefaultSchema(), encodingStyles[i]);
            encodingToNamespaces.put(encodingStyles[i], encodingStyleNamespaces);
            ++i;
        }
    }

    public static synchronized void clear() throws ParseException, IOException, SchemaException {
        if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
            Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)"clearing cached mappings");
        }
        namespaceToPackage.clear();
        packageToNamespace.clear();
        mapFilePaths.clear();
        defaultPackage = null;
        namespacePrefix = SchemaProperties.getTmePackage();
        mappings = new Mapping[0];
        Mappings.setNamespaces();
        Mappings.readDefaultMappings();
    }

    public static void readMappings() throws ParseException, IOException, SchemaException {
        Mappings.readDefaultMappings();
        String userMapPath = Context.application().getStringProperty("electric.mappings");
        Mappings.readMappings(userMapPath != null ? userMapPath : ILoaderConstants.DEFAULT_MAP_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readDefaultMappings() throws ParseException, IOException, SchemaException {
        MapFile[] mapFiles;
        block22: {
            Throwable throwable2222222222;
            mapFiles = null;
            mapFiles = mapFileLoader.loadMapFiles("standard.map");
            try {
                if (mapFiles == null) {
                    mapFiles = mapFileLoader.loadMapFiles("default-standard.map");
                }
                if (mapFiles != null) {
                    int i = 0;
                    while (i < mapFiles.length) {
                        Mappings.readMapping(mapFiles[i].path, mapFiles[i].document);
                        ++i;
                    }
                }
                break block22;
            }
            catch (SecurityException exception1) {}
            break block22;
            catch (SecurityException exception) {
                try {
                    if (mapFiles == null) {
                        mapFiles = mapFileLoader.loadMapFiles("default-standard.map");
                    }
                    if (mapFiles != null) {
                        int i = 0;
                        while (i < mapFiles.length) {
                            Mappings.readMapping(mapFiles[i].path, mapFiles[i].document);
                            ++i;
                        }
                    }
                    break block22;
                }
                catch (SecurityException exception1) {}
                break block22;
                catch (Throwable throwable2222222222) {
                    try {
                        if (mapFiles == null) {
                            mapFiles = mapFileLoader.loadMapFiles("default-standard.map");
                        }
                        if (mapFiles != null) {
                            int i = 0;
                            while (i < mapFiles.length) {
                                Mappings.readMapping(mapFiles[i].path, mapFiles[i].document);
                                ++i;
                            }
                        }
                    }
                    catch (SecurityException exception1) {
                        // empty catch block
                    }
                }
            }
            throw throwable2222222222;
        }
        if (mapFiles == null) {
            String warning = "neither standard.map nor default-standard.map could be loaded";
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)warning);
            }
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)warning);
            }
        }
    }

    public static void readMappings(String mapPath) throws ParseException, IOException, SchemaException {
        StringTokenizer tokenizer = new StringTokenizer(mapPath, ";");
        while (tokenizer.hasMoreTokens()) {
            try {
                MapFile[] mapFiles = mapFileLoader.loadMapFiles(tokenizer.nextToken());
                if (mapFiles == null) continue;
                int i = 0;
                while (i < mapFiles.length) {
                    Mappings.readMapping(mapFiles[i].path, mapFiles[i].document);
                    ++i;
                }
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static void readMapping(Document document) throws SchemaException {
        try {
            mapFileParser.parse(document);
        }
        catch (EncodingMismatchException exception) {
            // empty catch block
        }
        int i = 0;
        while (i < encodingStyles.length) {
            try {
                mapFileParser.parse(document, encodingStyles[i]);
            }
            catch (EncodingMismatchException exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void readMapping(String path, Document document) throws SchemaException {
        path = PathUtil.normalizeSlashes(path).toLowerCase();
        if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
            Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("parse mapping from " + path));
        }
        if (mapFilePaths.contains(path)) {
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("skipping duplicate path " + path));
            }
            return;
        }
        mapFilePaths.addElement(path);
        Mappings.readMapping(document);
    }

    public static void mapClass(Class javaClass, Class typeClass) {
        Mappings.mapClass(javaClass.getName(), typeClass.getName());
    }

    public static void mapClass(String javaName, String typeName) {
        String packageName = Strings.getJavaPackage(javaName);
        String localName = Strings.getLocalJavaName(javaName);
        if (packageName == null) {
            Mappings.mapClass(javaName, namespacePrefix, localName, typeName);
        } else {
            Mappings.mapClass(javaName, namespacePrefix + packageName + "/", localName, typeName);
        }
    }

    public static void mapClass(Class javaClass, String namespace, String name, Class typeClass) {
        Mappings.mapClass(javaClass.getName(), namespace, name, typeClass.getName());
    }

    public static void mapClass(String javaName, String namespace, String name, String typeName) {
        Mappings.mapClass(javaName, namespace, name, typeName, true);
    }

    public static void mapClass(String javaName, String namespace, String name, String typeName, boolean dominant) {
        Mappings.mapClass(javaName, namespace, name, typeName, dominant, null);
        int i = 0;
        while (i < encodingStyles.length) {
            Mappings.mapClass(javaName, namespace, name, typeName, dominant, encodingStyles[i]);
            ++i;
        }
    }

    public static void mapClass(String javaName, String namespace, String name, String typeName, boolean dominant, String encodingStyle) {
        Mappings.addMapping(new Mapping(javaName, namespace, name, typeName, dominant, encodingStyle));
    }

    public static synchronized void addMapping(Mapping mapping) {
        mappings = (Mapping[])ArrayUtil.insertElement(mappings, mapping);
    }

    public static synchronized Mapping getMapping(String namespace, String name) {
        return Mappings.getMapping(namespace, name, null);
    }

    public static synchronized Mapping getMapping(String namespace, String name, String encodingStyle) {
        int i = 0;
        while (i < mappings.length) {
            if (namespace.equals(mappings[i].getNamespace()) && name.equals(mappings[i].getName()) && (encodingStyle == mappings[i].getEncodingStyle() || encodingStyle != null && encodingStyle.equals(mappings[i].getEncodingStyle()))) {
                return mappings[i];
            }
            ++i;
        }
        return null;
    }

    public static synchronized Mapping getMapping(String javaName) {
        Mapping nonDominantMatch = null;
        int i = 0;
        while (i < mappings.length) {
            if (javaName.equals(mappings[i].getJavaName())) {
                if (mappings[i].isDominant()) {
                    return mappings[i];
                }
                if (nonDominantMatch == null) {
                    nonDominantMatch = mappings[i];
                }
            }
            ++i;
        }
        return nonDominantMatch;
    }

    public static synchronized Mapping getMappingByEncoding(String javaName, String encodingStyle) {
        Mapping nonDominantMatch = null;
        int i = 0;
        while (i < mappings.length) {
            if (javaName.equals(mappings[i].getJavaName()) && (mappings[i].getEncodingStyle() == encodingStyle || mappings[i].getEncodingStyle() != null && mappings[i].getEncodingStyle().equals(encodingStyle))) {
                if (mappings[i].isDominant()) {
                    return mappings[i];
                }
                if (nonDominantMatch == null) {
                    nonDominantMatch = mappings[i];
                }
            }
            ++i;
        }
        return nonDominantMatch;
    }

    public static synchronized void mapPackage(String packageName, String namespace) {
        namespaceToPackage.put(namespace, packageName);
        packageToNamespace.put(packageName, namespace);
    }

    public static void setDefaultPackage(String defaultPackage) {
        Mappings.defaultPackage = defaultPackage;
    }

    public static String getDefaultPackage() {
        return defaultPackage;
    }

    public static synchronized String getPackage(String namespace) {
        String packageName = (String)namespaceToPackage.get(namespace);
        if (packageName != null) {
            return packageName;
        }
        if (defaultPackage != null) {
            return defaultPackage;
        }
        if (namespace.equals(namespacePrefix)) {
            return "";
        }
        if (namespace.startsWith(namespacePrefix)) {
            return namespace.substring(namespacePrefix.length(), namespace.length() - 1);
        }
        return null;
    }

    public static void setNamespacePrefix(String namespacePrefix) {
        Mappings.namespacePrefix = namespacePrefix;
    }

    public static String getNamespacePrefix() {
        return namespacePrefix;
    }

    public static synchronized String getNamespace(String packageName) {
        if (packageName == null) {
            return namespacePrefix;
        }
        String namespace = (String)packageToNamespace.get(packageName);
        return namespace != null ? namespace : namespacePrefix + packageName + "/";
    }

    public static String getJavaName(String namespace, String name) {
        String localName = Strings.asJavaName(name);
        String packageName = Mappings.getPackage(namespace);
        if (packageName == null) {
            return null;
        }
        return packageName.length() == 0 ? localName : packageName + "." + localName;
    }

    public static void setDirectFieldAccess(boolean flag) {
        All.setDirectFieldAccess(flag);
    }

    public static boolean getDirectFieldAccess() {
        return All.getDirectFieldAccess();
    }

    static {
        started = false;
        encodingStyles = new String[]{"", "http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/2003/05/soap-encoding"};
        encodingToNamespaces = new Hashtable();
        try {
            Mappings.startup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

