/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io;

import electric.util.array.ArrayUtil;
import electric.util.java.JavaNames;
import electric.util.named.IQNamed;
import electric.util.product.Product;
import electric.xml.Element;
import electric.xml.io.Mapping;
import electric.xml.io.Mappings;
import electric.xml.io.Type;
import electric.xml.io.TypeFactories;
import electric.xml.io.array.ArrayType;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.AnyType;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class Namespaces
implements ISchemaConstants {
    private String version;
    private String encodingStyle = "";
    private IQNamed[] items = new IQNamed[0];
    private TypeFactories typeFactories;
    private Hashtable tnsToSchema = new Hashtable();
    private boolean enforceEncodingStyle = true;

    Namespaces() {
        this.version = SchemaProperties.getDefaultSchema();
        this.typeFactories = new TypeFactories(this.encodingStyle);
    }

    public Namespaces(String version) {
        this(version, null);
    }

    public Namespaces(String version, String encodingStyle) {
        this.version = version;
        this.encodingStyle = encodingStyle;
        this.typeFactories = new TypeFactories(encodingStyle);
        this.initialize();
    }

    public synchronized void setEncodingStyle(String encodingStyle) {
        this.encodingStyle = encodingStyle;
        this.typeFactories = new TypeFactories(encodingStyle);
    }

    public synchronized String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setEnforceEncodingStyle(boolean enforce) {
        this.enforceEncodingStyle = enforce;
    }

    public boolean getEnforceEncodingStyle() {
        return this.enforceEncodingStyle;
    }

    void initialize() {
        this.addItem(new ArrayType(this, new AnyType()));
        try {
            int i = 0;
            while (i < ISchemaConstants.DOMINANT_SIMPLE_TYPE_NAMES.length) {
                Type simpleType;
                Mapping mapping = Mappings.getMapping(this.version, ISchemaConstants.DOMINANT_SIMPLE_TYPE_NAMES[i], this.encodingStyle);
                if (mapping != null && (simpleType = mapping.newType(this)) != null) {
                    simpleType.setDominant(true);
                    this.addType(simpleType);
                }
                ++i;
            }
        }
        catch (SchemaException exception) {
            exception.printStackTrace();
            StringBuffer message = new StringBuffer();
            message.append("could not create Namespaces with a version " + this.version + ".");
            message.append("exception thrown was " + exception);
            throw new IllegalArgumentException(message.toString());
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public IQNamed[] getItems() {
        return this.items;
    }

    public synchronized Enumeration getItems(Class javaClass) {
        Vector<IQNamed> vector = new Vector<IQNamed>();
        int i = 0;
        while (i < this.items.length) {
            if (javaClass.isInstance(this.items[i])) {
                vector.addElement(this.items[i]);
            }
            ++i;
        }
        return vector.elements();
    }

    public synchronized void addItem(IQNamed item) {
        this.items = (IQNamed[])ArrayUtil.addElement(this.items, item);
    }

    public synchronized void removeItem(IQNamed item) {
        this.items = (IQNamed[])ArrayUtil.removeElement(this.items, item);
    }

    public IQNamed getItem(String qname, Class javaClass) throws SchemaException {
        int colon = qname.lastIndexOf(58);
        if (colon == -1) {
            return this.getItem("", qname, javaClass);
        }
        return this.getItem(qname.substring(0, colon), qname.substring(colon + 1), javaClass);
    }

    public synchronized IQNamed getItem(String namespace, String name, Class javaClass) throws SchemaException {
        int i = 0;
        while (i < this.items.length) {
            IQNamed item = this.items[i];
            if (namespace.equals(item.getNamespace()) && name.equals(item.getName()) && javaClass.isInstance(item)) {
                return item;
            }
            ++i;
        }
        String qname = namespace.equals("") ? "" : namespace + ":";
        qname = qname + name;
        throw new SchemaException("could not find a " + javaClass.getName() + " with qname " + qname);
    }

    public Type getTypeWithJavaClass(Class javaClass) throws SchemaException {
        Type type = this.getCachedTypeWithJavaClass(javaClass);
        if (type != null) {
            return type;
        }
        type = this.typeFactories.newType(this, javaClass);
        return this.addType(type);
    }

    public Type getTypeWithQName(String qname) throws SchemaException {
        int colon = qname.lastIndexOf(58);
        if (colon == -1) {
            return this.getTypeWithQName("", qname);
        }
        return this.getTypeWithQName(qname.substring(0, colon), qname.substring(colon + 1));
    }

    public Type getTypeWithQName(String namespace, String name) throws SchemaException {
        Type type = this.getCachedTypeWithQName(namespace, name);
        if (type != null) {
            return type;
        }
        type = this.typeFactories.newType(this, namespace, name);
        return this.addType(type);
    }

    public Type getTypeWithQName(Element element, String qname) throws SchemaException {
        int colon = qname.lastIndexOf(58);
        if (colon == -1) {
            String namespace = element.getDefaultNamespace();
            if (namespace != null) {
                return this.getTypeWithQName(namespace, qname);
            }
            return this.getTypeWithQName("", qname);
        }
        String prefix = qname.substring(0, colon);
        String namespace = element.getNamespace(prefix);
        if (namespace == null) {
            throw new SchemaException("Could not find namespace for prefix " + prefix);
        }
        return this.getTypeWithQName(namespace, qname.substring(colon + 1));
    }

    public Type getTypeWithSchema(String namespace, String name, Element schema) throws SchemaException {
        return this.addType(this.typeFactories.newType(this, namespace, name, schema));
    }

    private synchronized Type addType(Type type) {
        Type match = this.getCachedTypeWithQName(type.getNamespace(), type.getName());
        if (match != null) {
            return match;
        }
        if (type instanceof ArrayType) {
            try {
                this.addType(((ArrayType)type).getComponentType());
            }
            catch (SchemaException exception) {
                // empty catch block
            }
        }
        try {
            Vector dependencies = new Vector();
            type.addDependencies(dependencies);
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                Type item = (Type)iterator.next();
                this.addType(item);
            }
        }
        catch (SchemaException e) {
            // empty catch block
        }
        this.items = (IQNamed[])ArrayUtil.addElement(this.items, type);
        return type;
    }

    public void cacheSchema(Schema schema) {
        this.tnsToSchema.put(schema.getTargetNamespace(), schema);
    }

    public Schema getSchema(String targetNamespace) {
        return (Schema)this.tnsToSchema.get(targetNamespace);
    }

    public Schema findSchema(String targetNamespace) {
        Schema schema = this.getSchema(targetNamespace);
        if (schema == null) {
            Schema mappingSchema;
            boolean qualifyElements = false;
            boolean qualifyAttributes = false;
            if (Mappings.getNamespacesForEncoding(this.encodingStyle) != null && (mappingSchema = Mappings.getNamespacesForEncoding(this.encodingStyle).getSchema(targetNamespace)) != null) {
                qualifyElements = mappingSchema.getQualifyElements();
                qualifyAttributes = mappingSchema.getQualifyAttributes();
            }
            schema = this.createSchema(targetNamespace, qualifyElements, qualifyAttributes);
        }
        return schema;
    }

    public Schema createSchema(String targetNamespace, boolean qualifyElements, boolean qualifyAttributes) {
        return new Schema(this, targetNamespace, SchemaProperties.getDefaultSchema(), qualifyElements, qualifyAttributes);
    }

    public Type getCachedTypeWithJavaClass(Class javaClass) throws SchemaException {
        IQNamed[] items = this.getItems();
        Type nonDominantMatch = null;
        int i = 0;
        while (i < items.length) {
            IQNamed item = items[i];
            if (item instanceof Type) {
                Type type = (Type)item;
                if (JavaNames.getJavaName(javaClass).equals(type.getJavaName())) {
                    if (type.isDominant()) {
                        return type;
                    }
                    if (nonDominantMatch == null) {
                        nonDominantMatch = type;
                    }
                }
            }
            ++i;
        }
        return nonDominantMatch;
    }

    public Type getCachedTypeWithJavaName(String javaName) throws SchemaException {
        IQNamed[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            Type type;
            IQNamed item = items[i];
            if (item instanceof Type && javaName.equals((type = (Type)item).getJavaName())) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private Type getCachedTypeWithQName(String namespace, String name) {
        IQNamed[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            IQNamed item = items[i];
            if (item instanceof Type) {
                Type type = (Type)item;
                if (namespace.equals(item.getNamespace()) && name.equals(item.getName())) {
                    return type;
                }
            }
            ++i;
        }
        return null;
    }

    static {
        Product.startup();
    }
}

