/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io;

import electric.util.Value;
import electric.util.classloader.ClassLoaders;
import electric.util.java.JavaNames;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.named.IQNamed;
import electric.util.reflect.Wrappers;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.xpath.TMEXPath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Type
implements IQNamed,
Cloneable,
ISchemaConstants,
IEXMLLoggingConstants {
    protected Schema schema;
    protected String name;
    protected String javaName;
    protected boolean inhibit;
    protected boolean dominant;
    protected boolean anonymous = false;
    private Hashtable classLoaderToClass = new Hashtable();
    private Object NO_CLASSLOADER = new Object();

    public Type() {
    }

    public Type(Schema schema, String name, Class javaClass) {
        this.schema = schema;
        this.name = name;
        this.setJavaClass(javaClass);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        return ((Type)object).getQName().equals(this.getQName());
    }

    public void setSchema(Schema schema) {
        if (this.schema != null && !Mappings.isMappingNamespaces(this.getNamespaces())) {
            this.schema.removeSchemaType(this);
        }
        schema.addSchemaType(this);
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.schema.setNamespaces(namespaces);
    }

    public Namespaces getNamespaces() {
        return this.schema.getNamespaces();
    }

    public String getNamespace() {
        return this.schema.getTargetNamespace();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQName() {
        if (this.schema.getTargetNamespace().equals("")) {
            return this.name;
        }
        return this.schema.getTargetNamespace() + ":" + this.name;
    }

    public String getJavaName() throws SchemaException {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getJavaClass() throws SchemaException {
        Class returnClass;
        Object key = ClassLoaders.getContextClassLoader();
        if (key == null) {
            key = this.NO_CLASSLOADER;
        }
        Hashtable hashtable = this.classLoaderToClass;
        synchronized (hashtable) {
            returnClass = (Class)this.classLoaderToClass.get(key);
            if (returnClass != null) {
                return returnClass;
            }
            returnClass = this.findJavaClass();
            if (returnClass != null) {
                this.classLoaderToClass.put(key, returnClass);
            }
        }
        return returnClass;
    }

    protected Class findJavaClass() throws SchemaException {
        try {
            return ClassLoaders.loadClass(this.getJavaName());
        }
        catch (ClassNotFoundException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "unable to load class for " + this.getJavaName(), exception);
            }
            return null;
        }
    }

    public Class getJavaClassWithCheck() throws SchemaException, ClassNotFoundException {
        Class type = this.getJavaClass();
        if (type != null) {
            return type;
        }
        throw new ClassNotFoundException("could not find class with name " + this.getJavaName());
    }

    public void setJavaClass(Class javaClass) {
        this.javaName = javaClass == null ? null : JavaNames.getJavaName(javaClass);
    }

    public boolean isStandard() {
        return false;
    }

    public boolean isInhibit() {
        return this.inhibit;
    }

    public void setInhibit(boolean inhibit) {
        this.inhibit = inhibit;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean useAnonymous() {
        return false;
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
    }

    public void addAllDependencies(Hashtable closure) throws SchemaException {
        if (closure.get(this) != null) {
            return;
        }
        closure.put(this, this);
        Vector dependencies = new Vector();
        this.addDependencies(dependencies);
        Enumeration enumeration = dependencies.elements();
        while (enumeration.hasMoreElements()) {
            ((Type)enumeration.nextElement()).addAllDependencies(closure);
        }
    }

    public boolean isMultiReference() {
        return true;
    }

    public static String getXSDPrefix(Element element) {
        return element.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
    }

    public static String getXSIPrefix(Element element) {
        return element.getPrefix(SchemaProperties.getDefaultSchema() + "-instance", "xsi");
    }

    public boolean useSchemaElement() {
        return false;
    }

    public SchemaElement getSchemaElement() throws SchemaException {
        return null;
    }

    public void writeSchema(Element schema) throws SchemaException {
    }

    public void writeSchema(Element schema, boolean annotated) throws SchemaException {
        this.writeSchema(schema);
    }

    public void readSchema(Element schema) throws SchemaException {
    }

    public void appendSchema(Element root, boolean annotated) throws SchemaException {
        TMEXPath xpath;
        Element schemaElement = null;
        if (this.getNamespace() == null || this.getNamespace().equals("")) {
            xpath = new TMEXPath("//schema");
            Elements elements = root.getRoot().getElements(xpath);
            while (elements.hasMoreElements()) {
                Element schema = elements.next();
                if (schema.hasAttribute("targetNamespace")) continue;
                schemaElement = schema;
                break;
            }
        } else {
            xpath = new TMEXPath("//schema[@targetNamespace='" + this.getNamespace() + "']");
            schemaElement = root.getRoot().getElement(xpath);
        }
        if (schemaElement == null) {
            schemaElement = root.addElement();
            String prefix = schemaElement.getPrefix(this.schema.getVersion(), "xsd");
            if (this.schema.getQualifyElements()) {
                schemaElement.setAttribute("elementFormDefault", "qualified");
            }
            if (this.schema.getQualifyAttributes()) {
                schemaElement.setAttribute("attributeFormDefault", "qualified");
            }
            if (this.getNamespace() != null && !this.getNamespace().equals("")) {
                schemaElement.setAttribute("targetNamespace", this.getNamespace());
            }
            schemaElement.setName(prefix, "schema");
        }
        this.writeSchema(schemaElement, annotated);
    }

    public void writeJava(JavaSource source) throws SchemaException {
    }

    public String getName(Element element) {
        return Type.getName(this.schema.getTargetNamespace(), this.name, element);
    }

    public String getName(Element element, Class javaClass) throws SchemaException {
        return this.getType(javaClass).getName(element);
    }

    public static String getName(String namespace, String name, Element element) {
        if (namespace.equals("") || namespace.equals(element.getDefaultNamespace())) {
            return name;
        }
        String prefix = element.getNamespacePrefix(namespace);
        if (prefix == null) {
            Element root = element.getRoot();
            prefix = "n" + root.getAttributeObjects().size();
            root.setNamespace(prefix, namespace);
        }
        return prefix + ":" + name;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void setDominant(boolean dominant) {
        this.dominant = dominant;
    }

    public Type getType(Class javaClass) throws SchemaException {
        return this.schema.getNamespaces().getTypeWithJavaClass(javaClass);
    }

    public Type getRuntimeType(Object object, Namespaces namespaces) throws SchemaException {
        if (this.getJavaClass().equals(object.getClass())) {
            return this;
        }
        if (this.getJavaClass().isPrimitive() && !object.getClass().isPrimitive() && Wrappers.getPrimitiveClass(object.getClass()).equals(this.getJavaClass())) {
            return this;
        }
        return namespaces.getTypeWithJavaClass(object.getClass());
    }

    public void writeType(IWriter writer) throws IOException {
        writer.writeType(this);
    }

    public abstract void writeObject(IWriter var1, Object var2) throws IOException;

    public abstract void readObject(IReader var1, Value var2) throws IOException;

    static Type clone(Type type) {
        try {
            return (Type)type.clone();
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }
}

