/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayTypeFactory;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.AnyType;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Vector;

public class ArrayType
extends Type {
    protected String item = "i";
    protected int minOccurs = 0;
    protected int maxOccurs = -1;
    protected Type componentType;
    protected String componentQName;
    private boolean isStandard = false;
    private static Hashtable componentNamespaceToNamespace = new Hashtable();
    private static Hashtable namespaceToComponentNamespace = new Hashtable();
    static /* synthetic */ Class class$java$lang$Void;

    public ArrayType(Namespaces namespaces, AnyType anyType) {
        super(namespaces.findSchema("http://schemas.xmlsoap.org/soap/encoding/"), "Array", class$java$lang$Void == null ? (class$java$lang$Void = ArrayType.class$("java.lang.Void")) : class$java$lang$Void);
        this.componentType = anyType;
        this.isStandard = true;
    }

    public ArrayType(Namespaces namespaces, Class javaClass) throws SchemaException {
        super(null, "", javaClass);
        this.componentType = namespaces.getTypeWithJavaClass(javaClass.getComponentType());
        String namespace = this.componentType.getNamespace();
        Schema schema = namespaces.findSchema(ArrayType.getArrayNamespace(namespace));
        this.setSchema(schema);
        this.setDominant(true);
        this.setName("ArrayOf" + this.componentType.getName());
    }

    public ArrayType(Schema schema, String name) {
        super(schema, name, null);
        this.setDominant(true);
    }

    public ArrayType(Namespaces namespaces, String namespace, String name, String componentQName, int maxOccurs) {
        super(namespaces.findSchema(namespace), name, null);
        this.setDominant(true);
        this.componentQName = componentQName;
        this.maxOccurs = maxOccurs;
    }

    public String toString() {
        try {
            return "ArrayType( name=" + this.getNamespace() + ":" + this.name + ", componentType=" + this.getComponentType() + ", dimensions=[" + this.maxOccurs + "] )";
        }
        catch (SchemaException exception) {
            return "ArrayType( " + exception + " )";
        }
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        dependencies.addElement(this.getComponentType());
    }

    public String getComponentQName() {
        return this.componentQName;
    }

    public synchronized Type getComponentType() throws SchemaException {
        if (this.componentType == null) {
            this.componentType = this.getNamespaces().getTypeWithQName(this.componentQName);
        }
        return this.componentType;
    }

    public static void addArrayNamespace(String componentNamespace, String namespace) {
        componentNamespaceToNamespace.put(componentNamespace, namespace);
        namespaceToComponentNamespace.put(namespace, componentNamespace);
    }

    public static String getArrayNamespace(String componentNamespace) {
        String namespace = (String)componentNamespaceToNamespace.get(componentNamespace);
        if (namespace != null) {
            return namespace;
        }
        return componentNamespace;
    }

    public static String getComponentNamespace(String arrayNamespace) {
        String namespace = (String)namespaceToComponentNamespace.get(arrayNamespace);
        if (namespace != null) {
            return namespace;
        }
        return arrayNamespace;
    }

    protected Class findJavaClass() {
        Class<?> javaClass;
        block3: {
            javaClass = null;
            try {
                Class componentClass = this.getComponentType().getJavaClass();
                if (this.maxOccurs == -1) {
                    javaClass = Array.newInstance(componentClass, 0).getClass();
                    break block3;
                }
                javaClass = Array.newInstance(componentClass, this.maxOccurs).getClass();
            }
            catch (Exception exception) {}
        }
        return javaClass;
    }

    public synchronized String getJavaName() throws SchemaException {
        if (this.javaName != null) {
            return this.javaName;
        }
        this.javaName = this.getComponentType().getJavaName() + "[]";
        return this.javaName;
    }

    public int[] getDimensions() {
        return new int[]{this.maxOccurs};
    }

    public String getArrayTypeQName(Object object, Element element, int[] dimensions, boolean writeSize) throws IOException {
        if (dimensions.length != 1) {
            throw new IOException("Attempt to write array with invalid length.");
        }
        Type runtimeComponentType = this.getComponentType();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Object array = object;
        int dimension = 0;
        if (array != null) {
            int length = Array.getLength(array);
            if (dimensions[0] != -1 && dimensions[0] < length) {
                throw new IOException("array too large for the dimensions specified in the wsdl.");
            }
            if (length == 0) {
                dimension = 0;
                array = null;
            } else {
                Object member = Array.get(array, 0);
                int j = 0;
                while (j < length && member == null) {
                    member = Array.get(array, j);
                    ++j;
                }
                dimension = length;
                array = member;
            }
        } else if (dimensions[0] == -1) {
            dimension = 0;
        }
        if (dimension != 0 && writeSize) {
            buffer.append(dimension);
        }
        if (runtimeComponentType instanceof ArrayType) {
            buffer.insert(0, ((ArrayType)runtimeComponentType).getArrayTypeQName(array, element, (int[])((ArrayType)runtimeComponentType).getDimensions().clone(), false));
        } else {
            buffer.insert(0, runtimeComponentType.getName(element));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getArrayTypeQName(Element element) throws SchemaException {
        Type runtimeComponentType = this.getComponentType();
        StringBuffer buffer = new StringBuffer();
        buffer.append(runtimeComponentType.getName(element));
        buffer.append("[");
        if (this.maxOccurs > 0) {
            buffer.append(this.maxOccurs);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void writeSchema(Element schema) throws SchemaException {
        String soapPrefix = schema.getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        String wsdlPrefix = schema.getPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        String xsdPrefix = Type.getXSDPrefix(schema);
        SchemaLocations.appendImport(schema, "http://schemas.xmlsoap.org/soap/encoding/", null);
        if (!this.getComponentType().getNamespace().equals(this.getNamespace()) && !this.getComponentType().useAnonymous()) {
            SchemaLocations.appendImport(schema, this.getComponentType().getNamespace(), null);
        }
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", this.getName());
        Element complexContent = complexType.addElement(xsdPrefix, "complexContent");
        Element restriction = complexContent.addElement(xsdPrefix, "restriction");
        restriction.setAttribute("base", soapPrefix + ":Array");
        Element attribute = restriction.addElement(xsdPrefix, "attribute");
        attribute.setAttribute("ref", soapPrefix + ":arrayType");
        try {
            attribute.setAttribute(wsdlPrefix, "arrayType", this.getArrayTypeQName(schema));
        }
        catch (SchemaException e) {
            throw new SchemaException("array type failed with exception: " + e.getMessage());
        }
    }

    public void writeType(IWriter writer) throws IOException {
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        String soapPrefix = writer.getElement().getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        String arrayTypeQName = this.getArrayTypeQName(object, writer.getElement(), (int[])this.getDimensions().clone(), true);
        writer.writeAttribute(soapPrefix, "arrayType", arrayTypeQName);
        int i = 0;
        while (i < Array.getLength(object)) {
            writer.writeObject(this.item, Array.get(object, i), this.getComponentType());
            ++i;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Type runtimeComponentType = this;
        String xmlType = reader.readAttributeValue("arrayType");
        xmlType = reader.getElement().getQName(xmlType);
        if (xmlType != null) {
            Namespaces ns = this.getNamespaces();
            if (ns == null) {
                ns = new Namespaces(SchemaProperties.getDefaultSchema());
            }
            if ((runtimeComponentType = ns.getTypeWithQName(xmlType)) != this) {
                runtimeComponentType.readObject(reader, value);
                return;
            }
            xmlType = ArrayTypeFactory.getComponentQName(xmlType);
            runtimeComponentType = this.getNamespaces().getTypeWithQName(xmlType);
        }
        int numElements = reader.getElement().getElements().size();
        Object array = Array.newInstance(runtimeComponentType.getJavaClass(), numElements);
        IReader[] children = reader.getReaders();
        int i = 0;
        while (i < children.length) {
            Array.set(array, i, children[i].readValue(runtimeComponentType).getObject());
            ++i;
        }
        value.setObject(array);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

