/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex.factories;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.MethodLookup;
import electric.util.reflect.Reflect;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.complex.IFactory;
import electric.xml.io.complex.factories.ArgData;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class CustomFactory
implements IFactory,
ISchemaConstants,
ILoggingConstants {
    private String factoryString;
    private String factoryClassName;
    private String factoryMethodName;
    private ArgData[] factoryArguments;
    private boolean isConstructor;
    private Method factoryStaticMethod;
    private Constructor factoryConstructor;
    private ComplexType owner;

    public CustomFactory(ComplexType complexType, Element schemaElement) throws SchemaException {
        this.factoryString = schemaElement.getAttributeValue(SchemaProperties.getTmeMap(), "factory");
        int openParen = this.factoryString.indexOf(40);
        int closeParen = this.factoryString.indexOf(41);
        this.owner = complexType;
        if (openParen == -1 || closeParen == -1) {
            throw new SchemaException("missing (...) in map:factory in type " + complexType.getQName());
        }
        int lastDot = this.factoryString.lastIndexOf(46, openParen);
        if (lastDot == -1) {
            throw new SchemaException("missing class name in map:factory in type " + complexType.getQName());
        }
        this.resolveFactoryArguments();
        this.factoryClassName = this.factoryString.substring(0, lastDot).trim();
        this.factoryMethodName = this.factoryString.substring(lastDot + 1, openParen).trim();
        this.isConstructor = Strings.tail(this.factoryClassName, '.').equals(this.factoryMethodName);
    }

    public String toString() {
        return "CustomFactory( " + this.factoryString + " )";
    }

    private synchronized Method getFactoryStaticMethod() throws ClassNotFoundException, NoSuchMethodException, SchemaException {
        if (this.factoryStaticMethod != null) {
            return this.factoryStaticMethod;
        }
        Class[] argClasses = new Class[this.factoryArguments.length];
        int i = 0;
        while (i < this.factoryArguments.length) {
            argClasses[i] = this.factoryArguments[i].argEntry.getJavaClass();
            ++i;
        }
        Class javaClass = ClassLoaders.loadClass(this.factoryClassName);
        this.factoryStaticMethod = MethodLookup.getMethod(javaClass, this.factoryMethodName, argClasses);
        return this.factoryStaticMethod;
    }

    private synchronized Constructor getFactoryConstructor() throws ClassNotFoundException, NoSuchMethodException, SchemaException {
        if (this.factoryConstructor != null) {
            return this.factoryConstructor;
        }
        Class[] argClasses = new Class[this.factoryArguments.length];
        int i = 0;
        while (i < this.factoryArguments.length) {
            argClasses[i] = this.factoryArguments[i].argEntry.getJavaClass();
            ++i;
        }
        Class javaClass = ClassLoaders.loadClass(this.factoryClassName);
        this.factoryConstructor = MethodLookup.getConstructor(javaClass, argClasses);
        return this.factoryConstructor;
    }

    public Object newInstance(IReader reader) throws IOException {
        Object[] args = new Object[this.factoryArguments.length];
        int i = 0;
        while (i < args.length) {
            String name = this.factoryArguments[i].argName;
            Type type = this.factoryArguments[i].argEntry.getType();
            Class javaClass = type.getJavaClass();
            Value value = Value.NULL;
            if (this.factoryArguments[i].argEntry instanceof SchemaElement) {
                IReader argReader = reader.getReader(name);
                if (argReader != null) {
                    args[i] = argReader.readObject(type);
                    value = new Value(args[i], type.getJavaClass());
                }
            } else {
                String attribute = reader.readAttributeValue(name);
                if (attribute != null) {
                    args[i] = Reflect.valueOf(attribute, javaClass);
                    value = new Value(args[i], javaClass);
                }
            }
            reader.addProperty(name, value);
            ++i;
        }
        try {
            if (this.isConstructor) {
                return this.getFactoryConstructor().newInstance(args);
            }
            return this.getFactoryStaticMethod().invoke(null, args);
        }
        catch (InvocationTargetException exception) {
            Throwable throwable = exception.getTargetException();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception while invoking factory method", throwable);
            }
            throw new IOException(throwable.toString());
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception while invoking factory method", exception);
            }
            throw new IOException(exception.toString());
        }
    }

    private void resolveFactoryArguments() throws SchemaException {
        String arguments = this.factoryString.substring(this.factoryString.indexOf(40) + 1, this.factoryString.indexOf(41)).trim();
        StringTokenizer tokenizer = new StringTokenizer(arguments, ",");
        this.factoryArguments = new ArgData[0];
        while (tokenizer.hasMoreTokens()) {
            String argName = tokenizer.nextToken().trim();
            SchemaEntry argEntry = this.owner.getSchemaEntry(argName);
            ArgData factoryArgument = new ArgData(argName, argEntry);
            this.factoryArguments = (ArgData[])ArrayUtil.addElement(this.factoryArguments, factoryArgument);
        }
    }
}

