/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.documents;

import electric.util.Value;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;

public class DocumentType
extends Type {
    private static final Class BYTE_ARRAY = new byte[0].getClass();

    public DocumentType() {
        this.setInhibit(true);
    }

    public void writeSchema(Element schema) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "document");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element document = sequence.addElement(xsdPrefix, "element");
        document.setAttribute("name", "document");
        document.setAttribute("type", this.getName(document, BYTE_ARRAY));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        writer.writeObject("document", (Object)((Document)object).getBytes());
    }

    public void readObject(IReader reader, Value value) throws IOException {
        try {
            Document document = new Document((byte[])reader.readObject("document"));
            value.setObject(document);
        }
        catch (ParseException exception) {
            throw new IOException(exception.toString());
        }
    }
}

