/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.documents;

import electric.util.Value;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;

public class ElementType
extends Type {
    private static final Class BYTE_ARRAY = new byte[0].getClass();

    public ElementType() {
        this.setInhibit(true);
        this.name = "element";
    }

    public void writeSchema(Element schema) throws SchemaException {
        String xsdPrefix = schema.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "element");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element element = sequence.addElement(xsdPrefix, "element");
        element.setAttribute("name", "element");
        element.setAttribute("type", this.getName(element, BYTE_ARRAY));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        writer.writeObject("element", (Object)((Element)object).getBytes());
    }

    public void readObject(IReader reader, Value value) throws IOException {
        try {
            Document document = new Document((byte[])reader.readObject("element"));
            value.setObject(document.getRoot());
        }
        catch (ParseException exception) {
            throw new IOException(exception.toString());
        }
    }
}

