/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.wrapper;

import electric.util.Value;
import electric.util.reflect.Wrappers;
import electric.util.string.Base64;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.wrapper.WrapperType;
import java.io.IOException;

public final class ByteArrayType
extends WrapperType {
    private static final Class BYTE_ARRAY_CLASS = new Byte[0].getClass();
    private static final Byte[] NO_BYTES = new Byte[0];

    public ByteArrayType() {
        this("http://schemas.xmlsoap.org/soap/encoding/");
    }

    public ByteArrayType(String namespace) {
        super(namespace, "base64Binary", BYTE_ARRAY_CLASS);
        this.setJavaName("Byte[]");
    }

    public Class getJavaClass() {
        return BYTE_ARRAY_CLASS;
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        Byte[] bytes = (Byte[])object;
        if (bytes.length > 0) {
            writer.writeText(Base64.toBase64(bytes));
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        String text = reader.readString().trim();
        byte[] bytes = Base64.fromBase64(text);
        value.setObject(bytes.length == 0 ? NO_BYTES : Wrappers.convertToWrapperArray(bytes));
    }
}

