/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.xpath;

import electric.util.lex.Lex;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.Nodes;
import electric.xml.Parent;
import electric.xml.Selection;
import electric.xml.XPathException;
import electric.xml.xpath.NameNode;
import electric.xml.xpath.TMEXPath;
import java.io.IOException;

public class TextPredicate
extends NameNode {
    private String text;
    private boolean not;

    public TextPredicate(String string) throws XPathException {
        try {
            int equals;
            int openBracket = string.indexOf(91);
            if (openBracket > 0) {
                this.setName(string.substring(0, openBracket));
            }
            if ((equals = string.indexOf(61)) == -1) {
                throw new XPathException("missing = in " + string);
            }
            if (string.charAt(equals - 1) == '!') {
                this.not = true;
            }
            Lex lex = new Lex(string.substring(equals + 1));
            lex.skipWhitespace();
            int ch = lex.read();
            if (ch == 34) {
                this.text = lex.readToPattern("\"", 66);
            } else if (ch == 39) {
                this.text = lex.readToPattern("'", 66);
            } else {
                throw new XPathException("missing quote at start of text value");
            }
            lex.readChar(93);
        }
        catch (IOException exception) {
            throw new XPathException(exception.toString());
        }
    }

    public void addNodes(TMEXPath xpath, Node node, NodeList list) throws XPathException {
        NodeList selected = new NodeList();
        Elements elements = ((Parent)node).getElements();
        while (elements.hasMoreElements()) {
            Element element = elements.next();
            String elementText = element.getString();
            if (elementText == null || (!this.not ? !this.text.equals(elementText) : this.text.equals(elementText))) continue;
            if (this.name == null) {
                selected.append(new Selection(element));
                continue;
            }
            if (!element.hasName(this.getNamespace(xpath, element), this.name)) continue;
            selected.append(new Selection(element));
        }
        this.addNextNodes(xpath, new Nodes(selected), list);
    }
}

