/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.engine;

import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.persister.ClassPersister;

public final class Key
implements Serializable {
    private final Serializable identifier;
    private final Serializable identifierSpace;
    private final Class clazz;
    private final boolean isBatchLoadable;

    private Key(Serializable id, Serializable identifierSpace, Class clazz, boolean batchLoadable) {
        if (id == null) {
            throw new AssertionFailure("null identifier");
        }
        this.identifier = id;
        this.identifierSpace = identifierSpace;
        this.clazz = clazz;
        this.isBatchLoadable = batchLoadable;
    }

    public Key(Serializable id, ClassPersister p) {
        this(id, p.getIdentifierSpace(), p.getMappedClass(), p.isBatchLoadable());
    }

    public Serializable getIdentifier() {
        return this.identifier;
    }

    public Class getMappedClass() {
        return this.clazz;
    }

    public boolean isBatchLoadable() {
        return this.isBatchLoadable;
    }

    public boolean equals(Object other) {
        Key otherKey = (Key)other;
        return otherKey.identifierSpace.equals(this.identifierSpace) && otherKey.identifier.equals(this.identifier);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.identifierSpace.hashCode();
        result = 37 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        return this.identifier.toString();
    }
}

