/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.exception;

import java.sql.SQLException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.exception.ConstraintViolationException;
import net.sf.hibernate.exception.GenericJDBCException;
import net.sf.hibernate.exception.JDBCConnectionException;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.exception.LockAcquisitionException;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.SQLGrammarException;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;

public class ErrorCodeConverter
implements SQLExceptionConverter {
    private ViolatedConstraintNameExtracter extracter;

    public ErrorCodeConverter(ViolatedConstraintNameExtracter extracter) {
        this.extracter = extracter;
    }

    protected int[] getSQLGrammarErrorCodes() {
        return null;
    }

    protected int[] getConnectionErrorCodes() {
        return null;
    }

    protected int[] getIntegrityViolationErrorCodes() {
        return null;
    }

    protected int[] getLockAcquisitionErrorCodes() {
        return null;
    }

    public JDBCException convert(SQLException sqlException, String message) {
        int errorCode = JDBCExceptionHelper.extractErrorCode(sqlException);
        if (this.isMatch(this.getConnectionErrorCodes(), errorCode)) {
            return new JDBCConnectionException(message, sqlException);
        }
        if (this.isMatch(this.getSQLGrammarErrorCodes(), errorCode)) {
            return new SQLGrammarException(message, sqlException);
        }
        if (this.isMatch(this.getIntegrityViolationErrorCodes(), errorCode)) {
            String constraintName = this.extracter.extractConstraintName(sqlException);
            return new ConstraintViolationException(message, sqlException, constraintName);
        }
        if (this.isMatch(this.getLockAcquisitionErrorCodes(), errorCode)) {
            return new LockAcquisitionException(message, sqlException);
        }
        return this.handledNonSpecificException(sqlException, message);
    }

    protected JDBCException handledNonSpecificException(SQLException sqlException, String message) {
        return new GenericJDBCException(message, sqlException);
    }

    private boolean isMatch(int[] errorCodes, int errorCode) {
        if (errorCodes != null) {
            int max = errorCodes.length;
            for (int i = 0; i < max; ++i) {
                if (errorCodes[i] != errorCode) continue;
                return true;
            }
        }
        return false;
    }
}

