/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public abstract class AbstractCriterion
implements Criterion {
    public abstract String toString();

    private static Queryable getPropertyMapping(Class persistentClass, SessionFactoryImplementor sessionFactory) throws MappingException {
        return (Queryable)sessionFactory.getPersister(persistentClass);
    }

    protected static String[] getColumns(SessionFactoryImplementor sessionFactory, Class persistentClass, String property, String alias, Map aliasClasses) throws HibernateException {
        String root;
        Class clazz;
        if (property.indexOf(46) > 0 && (clazz = (Class)aliasClasses.get(root = StringHelper.root(property))) != null) {
            persistentClass = clazz;
            alias = root;
            property = property.substring(root.length() + 1);
        }
        return AbstractCriterion.getPropertyMapping(persistentClass, sessionFactory).toColumns(alias, property);
    }

    protected static Type getType(SessionFactoryImplementor sessionFactory, Class persistentClass, String property, Map aliasClasses) throws HibernateException {
        String root;
        Class clazz;
        if (property.indexOf(46) > 0 && (clazz = (Class)aliasClasses.get(root = StringHelper.root(property))) != null) {
            persistentClass = clazz;
            property = property.substring(root.length() + 1);
        }
        return AbstractCriterion.getPropertyMapping(persistentClass, sessionFactory).toType(property);
    }

    protected static TypedValue getTypedValue(SessionFactoryImplementor sessionFactory, Class persistentClass, String property, Object value, Map aliasClasses) throws HibernateException {
        return new TypedValue(AbstractCriterion.getType(sessionFactory, persistentClass, property, aliasClasses), value);
    }
}

