/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledDeletion
extends ScheduledEntityAction
implements SessionImpl.Executable,
Serializable {
    private final Object version;
    private CacheConcurrencyStrategy.SoftLock lock;

    public ScheduledDeletion(Serializable id, Object version, Object instance, ClassPersister persister, SessionImplementor session) {
        super(session, id, instance, persister);
        this.version = version;
    }

    public void execute() throws HibernateException {
        Serializable id = this.getId();
        ClassPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        if (persister.hasCache()) {
            this.lock = persister.getCache().lock(id, this.version);
        }
        persister.delete(id, this.version, instance, session);
        session.postDelete(instance);
        if (persister.hasCache()) {
            persister.getCache().evict(id);
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        if (this.getPersister().hasCache()) {
            this.getPersister().getCache().release(this.getId(), this.lock);
        }
    }
}

