/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OuterJoinLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.Select;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public class CollectionLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private final QueryableCollection collectionPersister;
    private final Type keyType;

    public CollectionLoader(QueryableCollection persister, SessionFactoryImplementor session) throws MappingException {
        this(persister, 1, session);
    }

    public CollectionLoader(QueryableCollection persister, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        super(factory.getDialect());
        this.collectionPersister = persister;
        this.keyType = persister.getKeyType();
        String alias = this.generateRootAlias(persister.getRole());
        List associations = this.walkCollectionTree(persister, alias, factory);
        this.initStatementString(persister, alias, associations, batchSize, factory);
        this.initClassPersisters(associations);
        this.postInstantiate();
    }

    private void initClassPersisters(List associations) {
        int joins = associations.size();
        this.lockModeArray = this.createLockModeArray(joins, LockMode.NONE);
        this.classPersisters = new Loadable[joins];
        this.owners = new int[joins];
        int i = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinLoader.OuterJoinableAssociation oj = (OuterJoinLoader.OuterJoinableAssociation)iter.next();
            this.classPersisters[i] = (Loadable)((Object)oj.joinable);
            this.owners[i] = this.toOwner(oj, joins, oj.isOneToOne);
            ++i;
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws SQLException, HibernateException {
        this.loadCollection(session, id, this.keyType);
    }

    private void initStatementString(QueryableCollection persister, String alias, List associations, int batchSize, SessionFactoryImplementor factory) throws MappingException {
        this.suffixes = CollectionLoader.generateSuffixes(associations.size());
        StringBuffer whereString = CollectionLoader.whereString(alias, persister.getKeyColumnNames(), batchSize);
        if (persister.hasWhere()) {
            whereString.append(" and ").append(persister.getSQLWhereString(alias));
        }
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select().setSelectClause(persister.selectFragment(alias) + this.selectString(associations, factory)).setFromClause(persister.getTableName(), alias).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString());
        if (persister.hasOrdering()) {
            select.setOrderByClause(persister.getSQLOrderByString(alias));
        }
        this.sql = select.toStatementString();
    }

    protected int getJoinType(AssociationType type, int config, String path, String table, String[] foreignKeyColumns, SessionFactoryImplementor factory) throws MappingException {
        int joinType = super.getJoinType(type, config, path, table, foreignKeyColumns, factory);
        if (joinType == 1 && "".equals(path)) {
            joinType = 0;
        }
        return joinType;
    }
}

