/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ldaptemplate;

import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.LimitExceededException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import net.sf.ldaptemplate.AttributesIntegrityViolationException;
import net.sf.ldaptemplate.BadLdapGrammarException;
import net.sf.ldaptemplate.EntryNotFoundException;
import net.sf.ldaptemplate.NamingExceptionTranslator;
import net.sf.ldaptemplate.SearchLimitExceededException;
import net.sf.ldaptemplate.UncategorizedLdapException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

public class DefaultNamingExceptionTranslator
implements NamingExceptionTranslator {
    public DataAccessException translate(NamingException namingException) {
        if (namingException instanceof NameNotFoundException) {
            return new EntryNotFoundException("Entry not found", namingException);
        }
        if (namingException instanceof InvalidSearchFilterException) {
            return new BadLdapGrammarException("Invalid search filter", namingException);
        }
        if (namingException instanceof InvalidSearchControlsException) {
            return new InvalidDataAccessApiUsageException("Invalid search controls supplied by internal API", (Throwable)namingException);
        }
        if (namingException instanceof NameAlreadyBoundException) {
            return new DataIntegrityViolationException("Name already bound", (Throwable)namingException);
        }
        if (namingException instanceof ContextNotEmptyException) {
            return new DataIntegrityViolationException("The context needs to be empty in order to be removed", (Throwable)namingException);
        }
        if (namingException instanceof InvalidAttributesException) {
            return new AttributesIntegrityViolationException("Invalid attributes", namingException);
        }
        if (namingException instanceof LimitExceededException) {
            return new SearchLimitExceededException("Too many objects found", namingException);
        }
        if (namingException instanceof CommunicationException) {
            throw new DataRetrievalFailureException("Unable to communicate with LDAP server", (Throwable)namingException);
        }
        return new UncategorizedLdapException("Operation failed", namingException);
    }
}

