/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.jms;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.MockObject;
import com.mockobjects.jms.MockTextMessage;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MockSession
extends MockObject
implements Session {
    protected ExpectationCounter myCloseCalls = new ExpectationCounter("MockSession.close");
    protected ExpectationCounter myCreateTextMessageCalls = new ExpectationCounter("MockSession.createTextMessage");
    private TextMessage myTextMessage = new MockTextMessage();
    private JMSException myException;
    private ObjectMessage objectMessageToReturn;

    public void setupCreateObjectMessage(ObjectMessage objectMessageToReturn) {
        this.objectMessageToReturn = objectMessageToReturn;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.objectMessageToReturn;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.objectMessageToReturn;
    }

    public void rollback() throws JMSException {
        this.notImplemented();
    }

    public void setupTextMessage(TextMessage textMessage) {
        this.myTextMessage = textMessage;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.notImplemented();
        return null;
    }

    public MapMessage createMapMessage() throws JMSException {
        this.notImplemented();
        return null;
    }

    public Message createMessage() throws JMSException {
        this.notImplemented();
        return null;
    }

    public boolean getTransacted() throws JMSException {
        this.notImplemented();
        return false;
    }

    public void recover() throws JMSException {
        this.notImplemented();
    }

    public void close() throws JMSException {
        this.throwExceptionIfAny();
        this.myCloseCalls.inc();
    }

    public void commit() throws JMSException {
        this.notImplemented();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.notImplemented();
    }

    public void setExpectedCloseCalls(int callCount) {
        this.myCloseCalls.setExpected(callCount);
    }

    public void setExpectedCreateTextMessageCalls(int callCount) {
        this.myCreateTextMessageCalls.setExpected(callCount);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.notImplemented();
        return null;
    }

    public TextMessage createTextMessage() throws JMSException {
        this.myCreateTextMessageCalls.inc();
        return this.myTextMessage;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.myTextMessage.setText(text);
        return this.myTextMessage;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.notImplemented();
        return null;
    }

    public void run() {
        this.notImplemented();
    }

    public void setupThrowException(JMSException e) {
        this.myException = e;
    }

    protected void throwExceptionIfAny() throws JMSException {
        if (null != this.myException) {
            throw this.myException;
        }
    }
}

