/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityConditionList
extends EntityCondition {
    protected List conditionList;
    protected EntityOperator operator;

    protected EntityConditionList() {
    }

    public EntityConditionList(List conditionList, EntityOperator operator) {
        this.conditionList = conditionList;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public EntityCondition getCondition(int index) {
        return (EntityCondition)this.conditionList.get(index);
    }

    public int getConditionListSize() {
        return this.conditionList.size();
    }

    public Iterator getConditionIterator() {
        return this.conditionList.iterator();
    }

    public String makeWhereString(ModelEntity modelEntity, List entityConditionParams) {
        StringBuffer whereStringBuffer = new StringBuffer();
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = (EntityCondition)this.conditionList.get(i);
                whereStringBuffer.append('(');
                whereStringBuffer.append(condition.makeWhereString(modelEntity, entityConditionParams));
                whereStringBuffer.append(')');
                if (i >= this.conditionList.size() - 1) continue;
                whereStringBuffer.append(' ');
                whereStringBuffer.append(this.operator.getCode());
                whereStringBuffer.append(' ');
            }
        }
        return whereStringBuffer.toString();
    }

    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        Iterator exprIter = this.conditionList.iterator();
        while (exprIter.hasNext()) {
            EntityCondition entityCondition = (EntityCondition)exprIter.next();
            entityCondition.checkCondition(modelEntity);
        }
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("[conditionList::");
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = (EntityCondition)this.conditionList.get(i);
                toStringBuffer.append(condition.toString());
                if (i <= 0) continue;
                toStringBuffer.append("::");
            }
        }
        toStringBuffer.append(']');
        return toStringBuffer.toString();
    }
}

