/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.config;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityConfException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralRuntimeException;
import org.ofbiz.core.util.UtilValidate;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityConfigUtil {
    public static final String ENTITY_ENGINE_XML_FILENAME = "entityengine.xml";
    protected static String txFactoryClass;
    protected static String txFactoryUserTxJndiName;
    protected static String txFactoryUserTxJndiServerName;
    protected static String txFactoryTxMgrJndiName;
    protected static String txFactoryTxMgrJndiServerName;
    protected static Map resourceLoaderInfos;
    protected static Map delegatorInfos;
    protected static Map entityModelReaderInfos;
    protected static Map entityGroupReaderInfos;
    protected static Map entityEcaReaderInfos;
    protected static Map fieldTypeInfos;
    protected static Map datasourceInfos;
    static /* synthetic */ Class class$org$ofbiz$core$entity$config$EntityConfigUtil;

    protected static Element getXmlRootElement() throws GenericEntityConfException {
        try {
            return ResourceLoader.getXmlRootElement((String)ENTITY_ENGINE_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericEntityConfException("Could not get entity engine XML root element", e);
        }
    }

    protected static Document getXmlDocument() throws GenericEntityConfException {
        try {
            return ResourceLoader.getXmlDocument((String)ENTITY_ENGINE_XML_FILENAME);
        }
        catch (GenericConfigException e) {
            throw new GenericEntityConfException("Could not get entity engine XML document", e);
        }
    }

    public static synchronized void reinitialize() throws GenericEntityException {
        try {
            ResourceLoader.invalidateDocument((String)ENTITY_ENGINE_XML_FILENAME);
            EntityConfigUtil.initialize(EntityConfigUtil.getXmlRootElement());
        }
        catch (Exception e) {
            throw new GenericEntityException("Error reloading entity config XML file entityengine.xml", e);
        }
    }

    public static void initialize(Element rootElement) throws GenericEntityException {
        Element curElement;
        Element transactionFactoryElement = UtilXml.firstChildElement((Element)rootElement, (String)"transaction-factory");
        if (transactionFactoryElement == null) {
            throw new GenericEntityConfException("ERROR: no transaction-factory definition was found in entityengine.xml");
        }
        txFactoryClass = transactionFactoryElement.getAttribute("class");
        Element userTxJndiElement = UtilXml.firstChildElement((Element)transactionFactoryElement, (String)"user-transaction-jndi");
        if (userTxJndiElement != null) {
            txFactoryUserTxJndiName = userTxJndiElement.getAttribute("jndi-name");
            txFactoryUserTxJndiServerName = userTxJndiElement.getAttribute("jndi-server-name");
        } else {
            txFactoryUserTxJndiName = null;
            txFactoryUserTxJndiServerName = null;
        }
        Element txMgrJndiElement = UtilXml.firstChildElement((Element)transactionFactoryElement, (String)"transaction-manager-jndi");
        if (txMgrJndiElement != null) {
            txFactoryTxMgrJndiName = txMgrJndiElement.getAttribute("jndi-name");
            txFactoryTxMgrJndiServerName = txMgrJndiElement.getAttribute("jndi-server-name");
        } else {
            txFactoryTxMgrJndiName = null;
            txFactoryTxMgrJndiServerName = null;
        }
        List childElements = null;
        Iterator elementIter = null;
        childElements = UtilXml.childElementList((Element)rootElement, (String)"resource-loader");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            ResourceLoaderInfo resourceLoaderInfo = new ResourceLoaderInfo(curElement);
            resourceLoaderInfos.put(resourceLoaderInfo.name, resourceLoaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"delegator");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            DelegatorInfo delegatorInfo = new DelegatorInfo(curElement);
            delegatorInfos.put(delegatorInfo.name, delegatorInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-model-reader");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            EntityModelReaderInfo entityModelReaderInfo = new EntityModelReaderInfo(curElement);
            entityModelReaderInfos.put(entityModelReaderInfo.name, entityModelReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-group-reader");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            EntityGroupReaderInfo entityGroupReaderInfo = new EntityGroupReaderInfo(curElement);
            entityGroupReaderInfos.put(entityGroupReaderInfo.name, entityGroupReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"entity-eca-reader");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            EntityEcaReaderInfo entityEcaReaderInfo = new EntityEcaReaderInfo(curElement);
            entityEcaReaderInfos.put(entityEcaReaderInfo.name, entityEcaReaderInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"field-type");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            FieldTypeInfo fieldTypeInfo = new FieldTypeInfo(curElement);
            fieldTypeInfos.put(fieldTypeInfo.name, fieldTypeInfo);
        }
        childElements = UtilXml.childElementList((Element)rootElement, (String)"datasource");
        elementIter = childElements.iterator();
        while (elementIter.hasNext()) {
            curElement = (Element)elementIter.next();
            DatasourceInfo datasourceInfo = new DatasourceInfo(curElement);
            datasourceInfos.put(datasourceInfo.name, datasourceInfo);
        }
    }

    public static String getTxFactoryClass() {
        return txFactoryClass;
    }

    public static String getTxFactoryUserTxJndiName() {
        return txFactoryUserTxJndiName;
    }

    public static String getTxFactoryUserTxJndiServerName() {
        return txFactoryUserTxJndiServerName;
    }

    public static String getTxFactoryTxMgrJndiName() {
        return txFactoryTxMgrJndiName;
    }

    public static String getTxFactoryTxMgrJndiServerName() {
        return txFactoryTxMgrJndiServerName;
    }

    public static ResourceLoaderInfo getResourceLoaderInfo(String name) {
        return (ResourceLoaderInfo)resourceLoaderInfos.get(name);
    }

    public static DelegatorInfo getDelegatorInfo(String name) {
        return (DelegatorInfo)delegatorInfos.get(name);
    }

    public static EntityModelReaderInfo getEntityModelReaderInfo(String name) {
        return (EntityModelReaderInfo)entityModelReaderInfos.get(name);
    }

    public static EntityGroupReaderInfo getEntityGroupReaderInfo(String name) {
        return (EntityGroupReaderInfo)entityGroupReaderInfos.get(name);
    }

    public static EntityEcaReaderInfo getEntityEcaReaderInfo(String name) {
        return (EntityEcaReaderInfo)entityEcaReaderInfos.get(name);
    }

    public static FieldTypeInfo getFieldTypeInfo(String name) {
        return (FieldTypeInfo)fieldTypeInfos.get(name);
    }

    public static DatasourceInfo getDatasourceInfo(String name) {
        return (DatasourceInfo)datasourceInfos.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        resourceLoaderInfos = new HashMap();
        delegatorInfos = new HashMap();
        entityModelReaderInfos = new HashMap();
        entityGroupReaderInfos = new HashMap();
        entityEcaReaderInfos = new HashMap();
        fieldTypeInfos = new HashMap();
        datasourceInfos = new HashMap();
        try {
            EntityConfigUtil.initialize(EntityConfigUtil.getXmlRootElement());
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Error loading entity config XML file entityengine.xml");
        }
    }

    public static class DatasourceInfo {
        public String name;
        public String helperClass;
        private String fieldTypeName;
        public List sqlLoadPaths = new LinkedList();
        public Element datasourceElement;
        public static final int TYPE_JNDI_JDBC = 1;
        public static final int TYPE_INLINE_JDBC = 2;
        public static final int TYPE_TYREX_DATA_SOURCE = 3;
        public static final int TYPE_OTHER = 4;
        public Element jndiJdbcElement;
        public Element tyrexDataSourceElement;
        public Element inlineJdbcElement;
        private String schemaName = null;
        public boolean checkOnStart = true;
        public boolean addMissingOnStart = false;
        public boolean useFks = true;
        public boolean useFkIndices = true;
        public boolean checkForeignKeysOnStart = false;
        public boolean checkFkIndicesOnStart = false;
        public boolean usePkConstraintNames = true;
        private Integer constraintNameClipLength = null;
        public String fkStyle = null;
        public boolean useFkInitiallyDeferred = true;
        public boolean useIndices = true;
        public boolean checkIndicesOnStart = false;
        public String joinStyle = null;
        protected static final Properties CONFIGURATION = new Properties();
        public static final String AUTO_FIELD_TYPE;
        public static final String AUTO_SCHEMA_NAME;
        public static final String AUTO_CONSTRAINT_NAME_CLIP_LENGTH;
        public static final int DEFAULT_CONSTRAINT_NAME_CLIP_LENGTH = 20;

        private static String getNonNullProperty(String propertyKey, String defaultValue) {
            String fieldValue = CONFIGURATION.getProperty(propertyKey);
            if (fieldValue != null) {
                return fieldValue;
            }
            Debug.logError((String)(propertyKey + " not set in the ofbiz-database.properties file. Using default value: " + defaultValue));
            return defaultValue;
        }

        public DatasourceInfo(Element element) {
            this.name = element.getAttribute("name");
            this.helperClass = element.getAttribute("helper-class");
            this.fieldTypeName = element.getAttribute("field-type-name");
            this.sqlLoadPaths = UtilXml.childElementList((Element)element, (String)"sql-load-path");
            this.datasourceElement = element;
            if (this.datasourceElement == null) {
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for schema-name (none)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for check-on-start (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for add-missing-on-start (false)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for use-foreign-keys (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default use-foreign-key-indices (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for check-fks-on-start (false)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for check-fk-indices-on-start (false)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for use-pk-constraint-names (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for constraint-name-clip-length (30)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for fk-style (name_constraint)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for use-fk-initially-deferred (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for use-indices (true)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for check-indices-on-start (false)"));
                Debug.logWarning((String)("datasource def not found with name " + this.name + ", using default for join-style (ansi)"));
            } else {
                this.schemaName = this.datasourceElement.getAttribute("schema-name");
                this.checkOnStart = !"false".equals(this.datasourceElement.getAttribute("check-on-start"));
                this.addMissingOnStart = "true".equals(this.datasourceElement.getAttribute("add-missing-on-start"));
                this.useFks = !"false".equals(this.datasourceElement.getAttribute("use-foreign-keys"));
                this.useFkIndices = !"false".equals(this.datasourceElement.getAttribute("use-foreign-key-indices"));
                this.checkForeignKeysOnStart = "true".equals(this.datasourceElement.getAttribute("check-fks-on-start"));
                this.checkFkIndicesOnStart = "true".equals(this.datasourceElement.getAttribute("check-fk-indices-on-start"));
                this.usePkConstraintNames = !"false".equals(this.datasourceElement.getAttribute("use-pk-constraint-names"));
                this.fkStyle = this.datasourceElement.getAttribute("fk-style");
                this.useFkInitiallyDeferred = "true".equals(this.datasourceElement.getAttribute("use-fk-initially-deferred"));
                this.useIndices = !"false".equals(this.datasourceElement.getAttribute("use-indices"));
                this.checkIndicesOnStart = "true".equals(this.datasourceElement.getAttribute("check-indices-on-start"));
                this.joinStyle = this.datasourceElement.getAttribute("join-style");
            }
            if (this.fkStyle == null || this.fkStyle.length() == 0) {
                this.fkStyle = "name_constraint";
            }
            if (this.joinStyle == null || this.joinStyle.length() == 0) {
                this.joinStyle = "ansi";
            }
            this.jndiJdbcElement = UtilXml.firstChildElement((Element)this.datasourceElement, (String)"jndi-jdbc");
            this.tyrexDataSourceElement = UtilXml.firstChildElement((Element)this.datasourceElement, (String)"tyrex-dataSource");
            this.inlineJdbcElement = UtilXml.firstChildElement((Element)this.datasourceElement, (String)"inline-jdbc");
        }

        public String getFieldTypeName() {
            if (AUTO_FIELD_TYPE.equals(this.fieldTypeName)) {
                this.fieldTypeName = this.findFieldTypeFromJDBCConnection();
            }
            return this.fieldTypeName;
        }

        public String getSchemaName() {
            if (AUTO_SCHEMA_NAME.equals(this.schemaName)) {
                this.schemaName = this.findSchemaNameFromJDBCConnection();
            }
            return this.schemaName;
        }

        public int getConstraintNameClipLength() {
            if (this.constraintNameClipLength == null) {
                if (AUTO_CONSTRAINT_NAME_CLIP_LENGTH.equals(this.datasourceElement.getAttribute("constraint-name-clip-length"))) {
                    this.constraintNameClipLength = new Integer(this.findConstraintNameClipLengthFromJDBCConnection());
                } else {
                    try {
                        this.constraintNameClipLength = new Integer(this.datasourceElement.getAttribute("constraint-name-clip-length"));
                    }
                    catch (Exception e) {
                        Debug.logError((String)("Could not parse constraint-name-clip-length value for datasource with name " + this.name + ", using default value of 30"));
                        this.constraintNameClipLength = new Integer(30);
                    }
                }
            }
            return this.constraintNameClipLength;
        }

        private String findFieldTypeFromJDBCConnection() {
            try {
                Connection connection = ConnectionFactory.getConnection(this.name);
                DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
                if (typeForConnection == null) {
                    Debug.logError((String)"Could not determine database type from ");
                }
                return typeForConnection.getFieldTypeName();
            }
            catch (Exception e) {
                String error = "Could not get connection to database to determine database type for " + AUTO_FIELD_TYPE;
                Debug.logError((Throwable)e, (String)error);
                throw new GeneralRuntimeException(error, (Throwable)e);
            }
        }

        private String findSchemaNameFromJDBCConnection() {
            try {
                Connection connection = ConnectionFactory.getConnection(this.name);
                DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
                if (typeForConnection == null) {
                    Debug.logError((String)"Could not determine database type from ");
                }
                return typeForConnection.getSchemaName(connection);
            }
            catch (Exception e) {
                String error = "Could not get connection to database to determine database schema-name for " + AUTO_SCHEMA_NAME;
                Debug.logError((Throwable)e, (String)error);
                throw new GeneralRuntimeException(error, (Throwable)e);
            }
        }

        private int findConstraintNameClipLengthFromJDBCConnection() {
            try {
                Connection connection = ConnectionFactory.getConnection(this.name);
                DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
                if (typeForConnection == null) {
                    Debug.logError((String)"Could not determine database type from ");
                }
                return typeForConnection.getConstraintNameClipLength();
            }
            catch (Exception e) {
                String error = "Could not get connection to database to determine database clip length";
                Debug.logError((Throwable)e, (String)error);
                return 20;
            }
        }

        static {
            try {
                CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", class$org$ofbiz$core$entity$config$EntityConfigUtil == null ? (class$org$ofbiz$core$entity$config$EntityConfigUtil = EntityConfigUtil.class$("org.ofbiz.core.entity.config.EntityConfigUtil")) : class$org$ofbiz$core$entity$config$EntityConfigUtil));
            }
            catch (Exception e) {
                Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
            }
            AUTO_FIELD_TYPE = DatasourceInfo.getNonNullProperty("fieldType.autoConfigue", "${auto-field-type-name}");
            AUTO_SCHEMA_NAME = DatasourceInfo.getNonNullProperty("schemaName.autoConfigure", "${auto-schema-name}");
            AUTO_CONSTRAINT_NAME_CLIP_LENGTH = DatasourceInfo.getNonNullProperty("constraintNameClipLength.autoConfigure", "${auto-constraint-name-clip-length}");
        }
    }

    public static class FieldTypeInfo {
        public String name;
        public Element resourceElement;

        public FieldTypeInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElement = element;
        }
    }

    public static class EntityEcaReaderInfo {
        public String name;
        public List resourceElements;

        public EntityEcaReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElements = UtilXml.childElementList((Element)element, (String)"resource");
        }
    }

    public static class EntityGroupReaderInfo {
        public String name;
        public Element resourceElement;

        public EntityGroupReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElement = element;
        }
    }

    public static class EntityModelReaderInfo {
        public String name;
        public List resourceElements;

        public EntityModelReaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.resourceElements = UtilXml.childElementList((Element)element, (String)"resource");
        }
    }

    public static class DelegatorInfo {
        public String name;
        public String entityModelReader;
        public String entityGroupReader;
        public String entityEcaReader;
        public boolean useDistributedCacheClear;
        public String distributedCacheClearClassName;
        public String distributedCacheClearUserLoginId;
        public Map groupMap = new HashMap();

        public DelegatorInfo(Element element) {
            this.name = element.getAttribute("name");
            this.entityModelReader = element.getAttribute("entity-model-reader");
            this.entityGroupReader = element.getAttribute("entity-group-reader");
            this.entityEcaReader = element.getAttribute("entity-eca-reader");
            this.useDistributedCacheClear = "true".equals(element.getAttribute("distributed-cache-clear-enabled"));
            this.distributedCacheClearClassName = element.getAttribute("distributed-cache-clear-class-name");
            if (UtilValidate.isEmpty((String)this.distributedCacheClearClassName)) {
                this.distributedCacheClearClassName = "org.ofbiz.core.extentity.EntityCacheServices";
            }
            this.distributedCacheClearUserLoginId = element.getAttribute("distributed-cache-clear-user-login-id");
            if (UtilValidate.isEmpty((String)this.distributedCacheClearUserLoginId)) {
                this.distributedCacheClearUserLoginId = "admin";
            }
            List groupMapList = UtilXml.childElementList((Element)element, (String)"group-map");
            Iterator groupMapIter = groupMapList.iterator();
            while (groupMapIter.hasNext()) {
                Element groupMapElement = (Element)groupMapIter.next();
                this.groupMap.put(groupMapElement.getAttribute("group-name"), groupMapElement.getAttribute("datasource-name"));
            }
        }
    }

    public static class ResourceLoaderInfo {
        public String name;
        public String className;
        public String prependEnv;
        public String prefix;

        public ResourceLoaderInfo(Element element) {
            this.name = element.getAttribute("name");
            this.className = element.getAttribute("class");
            this.prependEnv = element.getAttribute("prepend-env");
            this.prefix = element.getAttribute("prefix");
        }
    }
}

