/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.entity.GenericEntityConfException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelReader {
    public static final String module = (class$org$ofbiz$core$entity$model$ModelReader == null ? (class$org$ofbiz$core$entity$model$ModelReader = ModelReader.class$("org.ofbiz.core.entity.model.ModelReader")) : class$org$ofbiz$core$entity$model$ModelReader).getName();
    public static UtilCache readers = new UtilCache("entity.ModelReader", 0L, 0L);
    protected Map entityCache = null;
    protected int numEntities = 0;
    protected int numViewEntities = 0;
    protected int numFields = 0;
    protected int numRelations = 0;
    protected String modelName;
    protected Collection entityResourceHandlers;
    protected Map resourceHandlerEntities;
    protected Map entityResourceHandlerMap;
    static /* synthetic */ Class class$org$ofbiz$core$entity$model$ModelReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelReader getModelReader(String delegatorName) throws GenericEntityException {
        EntityConfigUtil.DelegatorInfo delegatorInfo = EntityConfigUtil.getDelegatorInfo(delegatorName);
        if (delegatorInfo == null) {
            throw new GenericEntityConfException("Could not find a delegator with the name " + delegatorName);
        }
        String tempModelName = delegatorInfo.entityModelReader;
        ModelReader reader = (ModelReader)readers.get((Object)tempModelName);
        if (reader == null) {
            Class clazz = class$org$ofbiz$core$entity$model$ModelReader == null ? (class$org$ofbiz$core$entity$model$ModelReader = ModelReader.class$("org.ofbiz.core.entity.model.ModelReader")) : class$org$ofbiz$core$entity$model$ModelReader;
            synchronized (clazz) {
                reader = (ModelReader)readers.get((Object)tempModelName);
                if (reader == null) {
                    reader = new ModelReader(tempModelName);
                    reader.getEntityCache();
                    readers.put((Object)tempModelName, (Object)reader);
                }
            }
        }
        return reader;
    }

    public ModelReader(String modelName) throws GenericEntityException {
        this.modelName = modelName;
        this.entityResourceHandlers = new LinkedList();
        this.resourceHandlerEntities = new HashMap();
        this.entityResourceHandlerMap = new HashMap();
        EntityConfigUtil.EntityModelReaderInfo entityModelReaderInfo = EntityConfigUtil.getEntityModelReaderInfo(modelName);
        if (entityModelReaderInfo == null) {
            throw new GenericEntityConfException("Cound not find an entity-model-reader with the name " + modelName);
        }
        List resourceElements = entityModelReaderInfo.resourceElements;
        Iterator resIter = resourceElements.iterator();
        while (resIter.hasNext()) {
            Element resourceElement = (Element)resIter.next();
            ResourceHandler handler = new ResourceHandler("entityengine.xml", resourceElement);
            this.entityResourceHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getEntityCache() throws GenericEntityException {
        if (this.entityCache == null) {
            Class clazz = class$org$ofbiz$core$entity$model$ModelReader == null ? (class$org$ofbiz$core$entity$model$ModelReader = ModelReader.class$("org.ofbiz.core.entity.model.ModelReader")) : class$org$ofbiz$core$entity$model$ModelReader;
            synchronized (clazz) {
                if (this.entityCache == null) {
                    this.numEntities = 0;
                    this.numViewEntities = 0;
                    this.numFields = 0;
                    this.numRelations = 0;
                    this.entityCache = new HashMap();
                    LinkedList<ModelEntity> tempViewEntityList = new LinkedList<ModelEntity>();
                    UtilTimer utilTimer = new UtilTimer();
                    Iterator rhIter = this.entityResourceHandlers.iterator();
                    while (rhIter.hasNext()) {
                        ResourceHandler entityResourceHandler = (ResourceHandler)rhIter.next();
                        Document document = null;
                        try {
                            document = entityResourceHandler.getDocument();
                        }
                        catch (GenericConfigException e) {
                            throw new GenericEntityConfException("Error getting document from resource handler", e);
                        }
                        if (document == null) {
                            Debug.logError((String)("Could not get document for " + entityResourceHandler.toString()));
                            this.entityCache = null;
                            return null;
                        }
                        Hashtable docElementValues = null;
                        docElementValues = new Hashtable();
                        Element docElement = document.getDocumentElement();
                        if (docElement == null) {
                            this.entityCache = null;
                            return null;
                        }
                        docElement.normalize();
                        Node curChild = docElement.getFirstChild();
                        int i = 0;
                        if (curChild != null) {
                            utilTimer.timerString("Before start of entity loop in " + entityResourceHandler.toString());
                            do {
                                boolean isEntity = "entity".equals(curChild.getNodeName());
                                boolean isViewEntity = "view-entity".equals(curChild.getNodeName());
                                if (!isEntity && !isViewEntity || curChild.getNodeType() != 1) continue;
                                ++i;
                                Element curEntity = (Element)curChild;
                                String entityName = UtilXml.checkEmpty((String)curEntity.getAttribute("entity-name"));
                                LinkedList<String> resourceHandlerEntityNames = (LinkedList<String>)this.resourceHandlerEntities.get(entityResourceHandler);
                                if (resourceHandlerEntityNames == null) {
                                    resourceHandlerEntityNames = new LinkedList<String>();
                                    this.resourceHandlerEntities.put(entityResourceHandler, resourceHandlerEntityNames);
                                }
                                resourceHandlerEntityNames.add(entityName);
                                if (this.entityCache.containsKey(entityName)) {
                                    Debug.logWarning((String)("WARNING: Entity " + entityName + " is defined more than once, most recent will over-write " + "previous definition(s)"), (String)module);
                                    Debug.logWarning((String)("WARNING: Entity " + entityName + " was found in " + entityResourceHandler + ", but was already defined in " + this.entityResourceHandlerMap.get(entityName).toString()), (String)module);
                                }
                                this.entityResourceHandlerMap.put(entityName, entityResourceHandler);
                                ModelEntity entity = null;
                                if (isEntity) {
                                    entity = this.createModelEntity(curEntity, docElement, null, docElementValues);
                                } else {
                                    entity = this.createModelViewEntity(curEntity, docElement, null, docElementValues);
                                    tempViewEntityList.add(entity);
                                }
                                if (entity != null) {
                                    this.entityCache.put(entityName, entity);
                                    if (isEntity) {
                                        if (!Debug.verboseOn()) continue;
                                        Debug.logVerbose((String)("-- [Entity]: #" + i + ": " + entityName), (String)module);
                                        continue;
                                    }
                                    if (!Debug.verboseOn()) continue;
                                    Debug.logVerbose((String)("-- [ViewEntity]: #" + i + ": " + entityName), (String)module);
                                    continue;
                                }
                                Debug.logWarning((String)("-- -- ENTITYGEN ERROR:getModelEntity: Could not create entity for entityName: " + entityName), (String)module);
                            } while ((curChild = curChild.getNextSibling()) != null);
                        } else {
                            Debug.logWarning((String)"No child nodes found.", (String)module);
                        }
                        utilTimer.timerString("Finished " + entityResourceHandler.toString() + " - Total Entities: " + i + " FINISHED");
                    }
                    for (int velInd = 0; velInd < tempViewEntityList.size(); ++velInd) {
                        ModelViewEntity curViewEntity = (ModelViewEntity)tempViewEntityList.get(velInd);
                        curViewEntity.populateFields(this.entityCache);
                    }
                    Debug.log((String)("FINISHED LOADING ENTITIES - ALL FILES; #Entities=" + this.numEntities + " #ViewEntities=" + this.numViewEntities + " #Fields=" + this.numFields + " #Relationships=" + this.numRelations), (String)module);
                }
            }
        }
        return this.entityCache;
    }

    public void rebuildResourceHandlerEntities() {
        this.resourceHandlerEntities = new HashMap();
        Iterator entityResourceIter = this.entityResourceHandlerMap.entrySet().iterator();
        while (entityResourceIter.hasNext()) {
            Map.Entry entry = entityResourceIter.next();
            LinkedList resourceHandlerEntityNames = (LinkedList)this.resourceHandlerEntities.get(entry.getValue());
            if (resourceHandlerEntityNames == null) {
                resourceHandlerEntityNames = new LinkedList();
                this.resourceHandlerEntities.put(entry.getValue(), resourceHandlerEntityNames);
            }
            resourceHandlerEntityNames.add(entry.getKey());
        }
    }

    public Iterator getResourceHandlerEntitiesKeyIterator() {
        if (this.resourceHandlerEntities == null) {
            return null;
        }
        return this.resourceHandlerEntities.keySet().iterator();
    }

    public Collection getResourceHandlerEntities(ResourceHandler resourceHandler) {
        if (this.resourceHandlerEntities == null) {
            return null;
        }
        return (Collection)this.resourceHandlerEntities.get(resourceHandler);
    }

    public void addEntityToResourceHandler(String entityName, String loaderName, String location) {
        this.entityResourceHandlerMap.put(entityName, new ResourceHandler("entityengine.xml", loaderName, location));
    }

    public ResourceHandler getEntityResourceHandler(String entityName) {
        return (ResourceHandler)this.entityResourceHandlerMap.get(entityName);
    }

    public ModelEntity getModelEntity(String entityName) throws GenericEntityException {
        Map ec = this.getEntityCache();
        if (ec == null) {
            throw new GenericEntityConfException("ERROR: Unable to load Entity Cache");
        }
        ModelEntity modelEntity = (ModelEntity)ec.get(entityName);
        if (modelEntity == null) {
            throw new GenericModelException("Could not find definition for entity name " + entityName);
        }
        return modelEntity;
    }

    public Iterator getEntityNamesIterator() throws GenericEntityException {
        Collection collection = this.getEntityNames();
        if (collection != null) {
            return collection.iterator();
        }
        return null;
    }

    public Collection getEntityNames() throws GenericEntityException {
        Map ec = this.getEntityCache();
        if (ec == null) {
            throw new GenericEntityConfException("ERROR: Unable to load Entity Cache");
        }
        return ec.keySet();
    }

    ModelEntity createModelEntity(Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable docElementValues) {
        if (entityElement == null) {
            return null;
        }
        ++this.numEntities;
        ModelEntity entity = new ModelEntity(this, entityElement, docElement, utilTimer, docElementValues);
        return entity;
    }

    ModelEntity createModelViewEntity(Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable docElementValues) {
        if (entityElement == null) {
            return null;
        }
        ++this.numViewEntities;
        ModelViewEntity entity = new ModelViewEntity(this, entityElement, docElement, utilTimer, docElementValues);
        return entity;
    }

    public ModelRelation createRelation(ModelEntity entity, Element relationElement) {
        ++this.numRelations;
        ModelRelation relation = new ModelRelation(entity, relationElement);
        return relation;
    }

    public ModelField findModelField(ModelEntity entity, String fieldName) {
        for (int i = 0; i < entity.fields.size(); ++i) {
            ModelField field = (ModelField)entity.fields.get(i);
            if (field.name.compareTo(fieldName) != 0) continue;
            return field;
        }
        return null;
    }

    public ModelField createModelField(Element fieldElement, Element docElement, Hashtable docElementValues) {
        if (fieldElement == null) {
            return null;
        }
        ++this.numFields;
        ModelField field = new ModelField(fieldElement);
        return field;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

