/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;
import org.w3c.dom.Element;

public class JNDIFactory
implements TransactionFactoryInterface {
    public static final String module = (class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory).getName();
    static TransactionManager transactionManager = null;
    static UserTransaction userTransaction = null;
    protected static Map dsCache = new HashMap();
    static /* synthetic */ Class class$org$ofbiz$core$entity$transaction$JNDIFactory;
    static /* synthetic */ Class class$org$ofbiz$core$entity$ConnectionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getTransactionManager() {
        if (transactionManager == null) {
            Class clazz = class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory;
            synchronized (clazz) {
                block11: {
                    if (transactionManager == null) {
                        try {
                            String jndiName = EntityConfigUtil.getTxFactoryTxMgrJndiName();
                            String jndiServerName = EntityConfigUtil.getTxFactoryTxMgrJndiServerName();
                            if (jndiName == null || jndiName.length() <= 0) break block11;
                            try {
                                InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                                if (ic != null) {
                                    transactionManager = (TransactionManager)ic.lookup(jndiName);
                                }
                            }
                            catch (NamingException ne) {
                                Debug.logWarning((Throwable)ne, (String)("NamingException while finding TransactionManager named " + jndiName + " in JNDI."), (String)module);
                                transactionManager = null;
                            }
                            if (transactionManager == null) {
                                Debug.logWarning((String)("[JNDIFactory.getTransactionManager] Failed to find TransactionManager named " + jndiName + " in JNDI."), (String)module);
                            }
                        }
                        catch (GeneralException e) {
                            Debug.logError((Throwable)e);
                            transactionManager = null;
                        }
                    }
                }
            }
        }
        return transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTransaction getUserTransaction() {
        if (userTransaction == null) {
            Class clazz = class$org$ofbiz$core$entity$transaction$JNDIFactory == null ? (class$org$ofbiz$core$entity$transaction$JNDIFactory = JNDIFactory.class$("org.ofbiz.core.entity.transaction.JNDIFactory")) : class$org$ofbiz$core$entity$transaction$JNDIFactory;
            synchronized (clazz) {
                block11: {
                    if (userTransaction == null) {
                        try {
                            String jndiName = EntityConfigUtil.getTxFactoryUserTxJndiName();
                            String jndiServerName = EntityConfigUtil.getTxFactoryUserTxJndiServerName();
                            if (jndiName == null || jndiName.length() <= 0) break block11;
                            try {
                                InitialContext ic = JNDIContextFactory.getInitialContext((String)jndiServerName);
                                if (ic != null) {
                                    userTransaction = (UserTransaction)ic.lookup(jndiName);
                                }
                            }
                            catch (NamingException ne) {
                                Debug.logWarning((Throwable)ne, (String)("NamingException while finding UserTransaction named " + jndiName + " in JNDI."), (String)module);
                                userTransaction = null;
                            }
                            if (userTransaction == null) {
                                Debug.logWarning((String)("[JNDIFactory.getUserTransaction] Failed to find UserTransaction named " + jndiName + " in JNDI."), (String)module);
                            }
                        }
                        catch (GeneralException e) {
                            Debug.logError((Throwable)e);
                            transactionManager = null;
                        }
                    }
                }
            }
        }
        return userTransaction;
    }

    public String getTxMgrName() {
        return "jndi";
    }

    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        EntityConfigUtil.DatasourceInfo datasourceInfo = EntityConfigUtil.getDatasourceInfo(helperName);
        if (datasourceInfo.jndiJdbcElement != null) {
            String jndiServerName;
            Element jndiJdbcElement = datasourceInfo.jndiJdbcElement;
            String jndiName = jndiJdbcElement.getAttribute("jndi-name");
            Connection con = JNDIFactory.getJndiConnection(jndiName, jndiServerName = jndiJdbcElement.getAttribute("jndi-server-name"));
            if (con != null) {
                return con;
            }
        } else {
            Debug.logError((String)("JNDI loaded is the configured transaction manager but no jndi-jdbc element was specified in the " + helperName + " datasource. Please check your configuration; will try other sources"));
        }
        if (datasourceInfo.inlineJdbcElement != null) {
            Connection otherCon = ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.inlineJdbcElement);
            return otherCon;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getJndiConnection(String jndiName, String jndiServerName) throws SQLException, GenericEntityException {
        Object ds = dsCache.get(jndiName);
        if (ds != null) {
            if (ds instanceof XADataSource) {
                XADataSource xads = (XADataSource)ds;
                return TransactionUtil.enlistConnection(xads.getXAConnection());
            }
            DataSource nds = (DataSource)ds;
            return nds.getConnection();
        }
        Class clazz = class$org$ofbiz$core$entity$ConnectionFactory == null ? (class$org$ofbiz$core$entity$ConnectionFactory = JNDIFactory.class$("org.ofbiz.core.entity.ConnectionFactory")) : class$org$ofbiz$core$entity$ConnectionFactory;
        synchronized (clazz) {
            ds = dsCache.get(jndiName);
            if (ds != null) {
                if (ds instanceof XADataSource) {
                    XADataSource xads = (XADataSource)ds;
                    return TransactionUtil.enlistConnection(xads.getXAConnection());
                }
                DataSource nds = (DataSource)ds;
                return nds.getConnection();
            }
            try {
                InitialContext ic;
                if (Debug.infoOn()) {
                    Debug.logInfo((String)("Doing JNDI lookup for name " + jndiName), (String)module);
                }
                if ((ic = JNDIContextFactory.getInitialContext((String)jndiServerName)) != null) {
                    ds = ic.lookup(jndiName);
                } else {
                    Debug.logWarning((String)("Initial Context returned was NULL for server name " + jndiServerName), (String)module);
                }
                if (ds != null) {
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)"Got a Datasource object.", (String)module);
                    }
                    dsCache.put(jndiName, ds);
                    Connection con = null;
                    if (ds instanceof XADataSource) {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got XADataSource for name " + jndiName), (String)module);
                        }
                        XADataSource xads = (XADataSource)ds;
                        XAConnection xac = xads.getXAConnection();
                        con = TransactionUtil.enlistConnection(xac);
                    } else {
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Got DataSource for name " + jndiName), (String)module);
                        }
                        DataSource nds = (DataSource)ds;
                        con = nds.getConnection();
                    }
                    return con;
                }
                Debug.logError((String)"Datasource returned was NULL.", (String)module);
            }
            catch (NamingException ne) {
                Debug.logWarning((Throwable)ne, (String)("[ConnectionFactory.getConnection] Failed to find DataSource named " + jndiName + " in JNDI server with name " + jndiServerName + ". Trying normal database."), (String)module);
            }
            catch (GenericConfigException gce) {
                throw new GenericEntityException("Problems with the JNDI configuration.", gce.getNested());
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

