/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.entity.transaction.TyrexConnectionFactory;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilURL;
import org.ofbiz.core.util.UtilValidate;
import org.w3c.dom.Element;
import tyrex.resource.ResourceException;
import tyrex.resource.Resources;
import tyrex.tm.DomainConfigurationException;
import tyrex.tm.RecoveryException;
import tyrex.tm.TransactionDomain;

public class TyrexFactory
implements TransactionFactoryInterface {
    protected static TransactionDomain td = null;
    protected static String DOMAIN_NAME = "default";

    public static Resources getResources() {
        if (td != null) {
            return td.getResources();
        }
        Debug.logWarning((String)"No Tyrex TransactionDomain, not returning resources");
        return null;
    }

    public static DataSource getDataSource(String dsName) {
        Resources resources = TyrexFactory.getResources();
        if (resources != null) {
            try {
                return (DataSource)resources.getResource(dsName);
            }
            catch (ResourceException e) {
                Debug.logError((Throwable)e, (String)("Could not get tyrex dataSource resource with name " + dsName));
                return null;
            }
        }
        return null;
    }

    public TransactionManager getTransactionManager() {
        if (td != null) {
            return td.getTransactionManager();
        }
        Debug.logWarning((String)"No Tyrex TransactionDomain, not returning TransactionManager");
        return null;
    }

    public UserTransaction getUserTransaction() {
        if (td != null) {
            return td.getUserTransaction();
        }
        Debug.logWarning((String)"No Tyrex TransactionDomain, not returning UserTransaction");
        return null;
    }

    public String getTxMgrName() {
        return "tyrex";
    }

    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        EntityConfigUtil.DatasourceInfo datasourceInfo = EntityConfigUtil.getDatasourceInfo(helperName);
        if (datasourceInfo.inlineJdbcElement != null) {
            try {
                Connection con = TyrexConnectionFactory.getConnection(helperName, datasourceInfo.inlineJdbcElement);
                if (con != null) {
                    return con;
                }
            }
            catch (Exception ex) {
                Debug.logError((Throwable)ex, (String)("Tyrex is the configured transaction manager but there was an error getting a database Connection through Tyrex for the " + helperName + " datasource. Please check your configuration, class path, etc."));
            }
            Connection otherCon = ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.inlineJdbcElement);
            return otherCon;
        }
        if (datasourceInfo.tyrexDataSourceElement != null) {
            Element tyrexDataSourceElement = datasourceInfo.tyrexDataSourceElement;
            String dataSourceName = tyrexDataSourceElement.getAttribute("dataSource-name");
            if (UtilValidate.isEmpty((String)dataSourceName)) {
                Debug.logError((String)("dataSource-name not set for tyrex-dataSource element in the " + helperName + " data-source definition"));
            } else {
                DataSource tyrexDataSource = TyrexFactory.getDataSource(dataSourceName);
                if (tyrexDataSource == null) {
                    Debug.logError((String)("Got a null data source for dataSource-name " + dataSourceName + " for tyrex-dataSource element in the " + helperName + " data-source definition; trying other sources"));
                } else {
                    Connection con = tyrexDataSource.getConnection();
                    if (con != null) {
                        return con;
                    }
                }
            }
            Connection otherCon = ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.inlineJdbcElement);
            return otherCon;
        }
        Debug.logError((String)("Tyrex is the configured transaction manager but no inline-jdbc or tyrex-dataSource element was specified in the " + helperName + " datasource. Please check your configuration"));
        return null;
    }

    static {
        td = TransactionDomain.getDomain((String)DOMAIN_NAME);
        if (td == null) {
            try {
                String resourceName = "tyrexdomain.xml";
                URL url = UtilURL.fromResource((String)resourceName);
                if (url != null) {
                    td = TransactionDomain.createDomain((String)url.toString());
                } else {
                    Debug.logError((String)("ERROR: Could not create Tyrex Transaction Domain (resource not found):" + resourceName));
                }
            }
            catch (DomainConfigurationException e) {
                Debug.logError((String)"Could not create Tyrex Transaction Domain (configuration):");
                Debug.logError((Throwable)e);
            }
            if (td != null) {
                Debug.logImportant((String)"Got TyrexDomain from classpath (NO tyrex.config file found)");
            }
        } else {
            Debug.logImportant((String)"Got TyrexDomain from tyrex.config location");
        }
        if (td != null) {
            try {
                td.recover();
            }
            catch (RecoveryException e) {
                Debug.logError((String)"Could not complete recovery phase of Tyrex TransactionDomain creation");
                Debug.logError((Throwable)e);
            }
        } else {
            Debug.logError((String)("Could not get Tyrex TransactionDomain for domain " + DOMAIN_NAME));
        }
    }
}

