/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.aspectj.util.PartialOrder;
import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.aop.aspectj.AspectJProxyUtils;
import org.springframework.aop.aspectj.autoproxy.AspectJPrecedenceComparator;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

public class AspectJAwareAdvisorAutoProxyCreator
extends AbstractAdvisorAutoProxyCreator {
    private static final Comparator DEFAULT_PRECEDENCE_COMPARATOR = new AspectJPrecedenceComparator();

    protected List sortAdvisors(List advisors) {
        LinkedList<PartiallyComparableAdvisorHolder> partiallyComparableAdvisors = new LinkedList<PartiallyComparableAdvisorHolder>();
        Iterator it = advisors.iterator();
        while (it.hasNext()) {
            Advisor element = (Advisor)it.next();
            PartiallyComparableAdvisorHolder advisor = new PartiallyComparableAdvisorHolder(element, DEFAULT_PRECEDENCE_COMPARATOR);
            partiallyComparableAdvisors.add(advisor);
        }
        List sorted = PartialOrder.sort(partiallyComparableAdvisors);
        if (sorted == null) {
            throw new IllegalArgumentException("Advice precedence circularity error");
        }
        LinkedList<Advisor> result = new LinkedList<Advisor>();
        Iterator it2 = sorted.iterator();
        while (it2.hasNext()) {
            PartiallyComparableAdvisorHolder pcAdvisor = (PartiallyComparableAdvisorHolder)it2.next();
            result.add(pcAdvisor.getAdvisor());
        }
        return result;
    }

    protected void extendAdvisors(List candidateAdvisors) {
        AspectJProxyUtils.makeAdvisorChainAspectJCapableIfNecessary(candidateAdvisors);
    }

    private static class PartiallyComparableAdvisorHolder
    implements PartialOrder.PartialComparable {
        private final Advisor advisor;
        private final Comparator comparator;

        public PartiallyComparableAdvisorHolder(Advisor advisor, Comparator comparator) {
            this.advisor = advisor;
            this.comparator = comparator;
        }

        public int compareTo(Object obj) {
            Advisor otherAdvisor = ((PartiallyComparableAdvisorHolder)obj).advisor;
            return this.comparator.compare(this.advisor, otherAdvisor);
        }

        public int fallbackCompareTo(Object obj) {
            return 0;
        }

        public Advisor getAdvisor() {
            return this.advisor;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Advice advice = this.advisor.getAdvice();
            sb.append(ClassUtils.getShortName(advice.getClass()));
            sb.append(": ");
            if (this.advisor instanceof Ordered) {
                sb.append("order " + ((Ordered)this.advisor).getOrder() + ", ");
            }
            if (advice instanceof AbstractAspectJAdvice) {
                AbstractAspectJAdvice ajAdvice = (AbstractAspectJAdvice)advice;
                sb.append(ajAdvice.getAspectName());
                sb.append(", declaration order ");
                sb.append(ajAdvice.getDeclarationOrder());
            }
            return sb.toString();
        }
    }
}

