/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.util.LittleEndian;

public class LineSpacingDescriptor
implements Cloneable {
    short _dyaLine;
    short _fMultiLinespace;

    public LineSpacingDescriptor() {
    }

    public LineSpacingDescriptor(byte[] byArray, int n) {
        this._dyaLine = LittleEndian.getShort(byArray, n);
        this._fMultiLinespace = LittleEndian.getShort(byArray, n + 2);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setMultiLinespace(short s) {
        this._fMultiLinespace = s;
    }

    public int toInt() {
        byte[] byArray = new byte[4];
        this.serialize(byArray, 0);
        return LittleEndian.getInt(byArray);
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putShort(byArray, n, this._dyaLine);
        LittleEndian.putShort(byArray, n + 2, this._fMultiLinespace);
    }

    public void setDyaLine(short s) {
        this._dyaLine = s;
    }

    public boolean equals(Object object) {
        LineSpacingDescriptor lineSpacingDescriptor = (LineSpacingDescriptor)object;
        return this._dyaLine == lineSpacingDescriptor._dyaLine && this._fMultiLinespace == lineSpacingDescriptor._fMultiLinespace;
    }
}

