/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUploadInterceptor
implements Interceptor {
    protected static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$interceptor$FileUploadInterceptor == null ? (class$com$opensymphony$webwork$interceptor$FileUploadInterceptor = FileUploadInterceptor.class$("com.opensymphony.webwork.interceptor.FileUploadInterceptor")) : class$com$opensymphony$webwork$interceptor$FileUploadInterceptor));
    protected Long maximumSize;
    protected String allowedTypes;
    protected String disallowedTypes;
    static /* synthetic */ Class class$com$opensymphony$webwork$interceptor$FileUploadInterceptor;

    public void setAllowedTypes(String allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    public void setDisallowedTypes(String disallowedTypes) {
        this.disallowedTypes = disallowedTypes;
    }

    public void setMaximumSize(Long maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        MultiPartRequestWrapper multiWrapper;
        if (!(ServletActionContext.getRequest() instanceof MultiPartRequestWrapper)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("bypass " + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName()));
            }
            return invocation.invoke();
        }
        ValidationAware validation = null;
        Action action = invocation.getAction();
        if (action instanceof ValidationAware) {
            validation = (ValidationAware)action;
        }
        if ((multiWrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest()).hasErrors()) {
            Collection errors = multiWrapper.getErrors();
            Iterator i = errors.iterator();
            while (i.hasNext()) {
                String error = (String)i.next();
                if (validation != null) {
                    validation.addActionError(error);
                }
                log.error((Object)error);
            }
        }
        Enumeration e = multiWrapper.getFileParameterNames();
        while (e.hasMoreElements()) {
            String inputName = (String)e.nextElement();
            String[] contentType = multiWrapper.getContentTypes(inputName);
            String[] fileName = multiWrapper.getFileNames(inputName);
            File[] file = multiWrapper.getFiles(inputName);
            if (file != null) {
                for (int i = 0; i < file.length; ++i) {
                    log.info((Object)("file " + inputName + " " + contentType[i] + " " + fileName[i] + " " + file[i]));
                }
            }
            if (file == null) {
                if (validation != null) {
                    validation.addFieldError(inputName, "Could not upload file(s). Perhaps it is too large?");
                }
                log.error((Object)("Error uploading: " + fileName));
                continue;
            }
            invocation.getInvocationContext().getParameters().put(inputName, file);
            invocation.getInvocationContext().getParameters().put(inputName + "ContentType", contentType);
            invocation.getInvocationContext().getParameters().put(inputName + "FileName", fileName);
        }
        String result = invocation.invoke();
        e = multiWrapper.getFileParameterNames();
        while (e.hasMoreElements()) {
            String inputValue = (String)e.nextElement();
            File[] file = multiWrapper.getFiles(inputValue);
            for (int i = 0; i < file.length; ++i) {
                File f = file[i];
                log.info((Object)("removing file " + inputValue + " " + f));
                if (f == null || !f.isFile()) continue;
                f.delete();
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

