/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import java.util.Vector;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISO8601DateConverter
extends AbstractBasicConverter {
    private DateTimeFormatter[] formatters = this.createISOFormatters();
    static /* synthetic */ Class class$java$util$Date;

    public boolean canConvert(Class type) {
        return type.equals(class$java$util$Date == null ? (class$java$util$Date = ISO8601DateConverter.class$("java.util.Date")) : class$java$util$Date);
    }

    protected Object fromString(String str) {
        for (int i = 0; i < this.formatters.length; ++i) {
            DateTimeFormatter formatter = this.formatters[i];
            try {
                DateTime dt = formatter.parseDateTime(str);
                return dt.toDate();
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        throw new ConversionException("Cannot parse date " + str);
    }

    protected String toString(Object obj) {
        DateTime dt = new DateTime(obj);
        return dt.toString();
    }

    private DateTimeFormatter[] createISOFormatters() {
        ISODateTimeFormat isoFormat = ISODateTimeFormat.getInstance();
        Vector<DateTimeFormatter> isoFormatters = new Vector<DateTimeFormatter>();
        isoFormatters.add(isoFormat.dateTime());
        isoFormatters.add(isoFormat.dateTimeNoMillis());
        isoFormatters.add(isoFormat.basicDate());
        isoFormatters.add(isoFormat.basicDateTime());
        isoFormatters.add(isoFormat.basicDateTimeNoMillis());
        isoFormatters.add(isoFormat.basicTime());
        isoFormatters.add(isoFormat.basicTimeNoMillis());
        isoFormatters.add(isoFormat.basicTTime());
        isoFormatters.add(isoFormat.basicTTimeNoMillis());
        isoFormatters.add(isoFormat.basicWeekDate());
        isoFormatters.add(isoFormat.basicWeekDateTime());
        isoFormatters.add(isoFormat.basicWeekDateTimeNoMillis());
        isoFormatters.add(isoFormat.date());
        isoFormatters.add(isoFormat.dateHour());
        isoFormatters.add(isoFormat.dateHourMinute());
        isoFormatters.add(isoFormat.dateHourMinuteSecond());
        isoFormatters.add(isoFormat.dateHourMinuteSecondFraction());
        isoFormatters.add(isoFormat.dateHourMinuteSecondMillis());
        isoFormatters.add(isoFormat.hour());
        isoFormatters.add(isoFormat.hourMinute());
        isoFormatters.add(isoFormat.hourMinuteSecond());
        isoFormatters.add(isoFormat.hourMinuteSecondFraction());
        isoFormatters.add(isoFormat.hourMinuteSecondMillis());
        isoFormatters.add(isoFormat.time());
        isoFormatters.add(isoFormat.timeNoMillis());
        isoFormatters.add(isoFormat.tTime());
        isoFormatters.add(isoFormat.tTimeNoMillis());
        isoFormatters.add(isoFormat.weekDate());
        isoFormatters.add(isoFormat.weekDateTime());
        isoFormatters.add(isoFormat.weekDateTimeNoMillis());
        isoFormatters.add(isoFormat.weekyear());
        isoFormatters.add(isoFormat.weekyearWeek());
        isoFormatters.add(isoFormat.weekyearWeekDay());
        return isoFormatters.toArray(new DateTimeFormatter[isoFormatters.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

