/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.IntQueue;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.QNameMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxReader
implements HierarchicalStreamReader,
XMLStreamConstants {
    private final QNameMap qnameMap;
    private final XMLStreamReader in;
    private final FastStack elementStack = new FastStack(16);
    private final IntQueue lookaheadQueue = new IntQueue(4);
    private boolean hasMoreChildrenCached;
    private boolean hasMoreChildrenResult;

    public StaxReader(QNameMap qnameMap, XMLStreamReader in) {
        this.qnameMap = qnameMap;
        this.in = in;
        this.moveDown();
    }

    public boolean hasMoreChildren() {
        if (this.hasMoreChildrenCached) {
            return this.hasMoreChildrenResult;
        }
        while (true) {
            switch (this.lookahead()) {
                case 1: {
                    this.hasMoreChildrenCached = true;
                    this.hasMoreChildrenResult = true;
                    return true;
                }
                case 2: 
                case 8: {
                    this.hasMoreChildrenCached = true;
                    this.hasMoreChildrenResult = false;
                    return false;
                }
            }
        }
    }

    private int lookahead() {
        try {
            int event = this.in.next();
            this.lookaheadQueue.write(event);
            return event;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    private int next() {
        if (!this.lookaheadQueue.isEmpty()) {
            return this.lookaheadQueue.read();
        }
        try {
            return this.in.next();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public void moveDown() {
        this.hasMoreChildrenCached = false;
        int currentDepth = this.elementStack.size();
        while (this.elementStack.size() <= currentDepth) {
            this.read();
            if (this.elementStack.size() >= currentDepth) continue;
            throw new RuntimeException();
        }
    }

    public void moveUp() {
        this.hasMoreChildrenCached = false;
        int currentDepth = this.elementStack.size();
        while (this.elementStack.size() >= currentDepth) {
            this.read();
        }
    }

    public String getNodeName() {
        return (String)this.elementStack.peek();
    }

    public String getValue() {
        String last = null;
        StringBuffer buffer = null;
        int value = this.lookahead();
        while (true) {
            if (value == 4) {
                String text = this.in.getText();
                if (text != null && text.length() > 0) {
                    if (last == null) {
                        last = text;
                    } else {
                        if (buffer == null) {
                            buffer = new StringBuffer(last);
                        }
                        buffer.append(text);
                    }
                }
            } else if (value != 5) break;
            value = this.lookahead();
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return last == null ? "" : last;
    }

    public String getAttribute(String name) {
        return this.in.getAttributeValue(null, name);
    }

    public Object peekUnderlyingNode() {
        throw new UnsupportedOperationException();
    }

    private void read() {
        switch (this.next()) {
            case 1: {
                QName qname = this.in.getName();
                String jname = this.qnameMap.getJavaClassName(qname);
                this.elementStack.push(jname);
                break;
            }
            case 2: 
            case 8: {
                this.elementStack.pop();
            }
        }
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.in.getLocation().getLineNumber()));
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }
}

