/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class StoreAppender {
    private static Log log = LogFactory.getLog((Class)StoreAppender.class);
    private static Class[] persistables = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};

    public void printCloseTag(PrintWriter aWriter, StoreDescription aDesc) throws Exception {
        aWriter.print("</");
        aWriter.print(aDesc.getTag());
        aWriter.println(">");
    }

    public void printOpenTag(PrintWriter aWriter, int indent, Object bean, StoreDescription aDesc) throws Exception {
        aWriter.print("<");
        aWriter.print(aDesc.getTag());
        if (aDesc.isAttributes() && bean != null) {
            this.printAttributes(aWriter, indent, bean, aDesc);
        }
        aWriter.println(">");
    }

    public void printTag(PrintWriter aWriter, int indent, Object bean, StoreDescription aDesc) throws Exception {
        aWriter.print("<");
        aWriter.print(aDesc.getTag());
        if (aDesc.isAttributes() && bean != null) {
            this.printAttributes(aWriter, indent, bean, aDesc);
        }
        aWriter.println("/>");
    }

    public void printTagContent(PrintWriter aWriter, String tag, String content) throws Exception {
        aWriter.print("<");
        aWriter.print(tag);
        aWriter.print(">");
        aWriter.print(this.convertStr(content));
        aWriter.print("</");
        aWriter.print(tag);
        aWriter.println(">");
    }

    public void printTagValueArray(PrintWriter aWriter, String tag, int indent, String[] elements) {
        if (elements != null && elements.length > 0) {
            this.printIndent(aWriter, indent + 2);
            aWriter.print("<");
            aWriter.print(tag);
            aWriter.print(">");
            for (int i = 0; i < elements.length; ++i) {
                this.printIndent(aWriter, indent + 4);
                aWriter.print(elements[i]);
                if (i + 1 >= elements.length) continue;
                aWriter.println(",");
            }
            this.printIndent(aWriter, indent + 2);
            aWriter.print("</");
            aWriter.print(tag);
            aWriter.println(">");
        }
    }

    public void printTagArray(PrintWriter aWriter, String tag, int indent, String[] elements) throws Exception {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                this.printIndent(aWriter, indent);
                this.printTagContent(aWriter, tag, elements[i]);
            }
        }
    }

    public void printIndent(PrintWriter aWriter, int indent) {
        for (int i = 0; i < indent; ++i) {
            aWriter.print(' ');
        }
    }

    public void printAttributes(PrintWriter writer, int indent, Object bean, StoreDescription desc) throws Exception {
        this.printAttributes(writer, indent, true, bean, desc);
    }

    public void printAttributes(PrintWriter writer, int indent, boolean include, Object bean, StoreDescription desc) throws Exception {
        PropertyDescriptor[] descriptors;
        String className = bean.getClass().getName();
        if (include && desc != null && !desc.isStandard()) {
            writer.print(" className=\"");
            writer.print(bean.getClass().getName());
            writer.print("\"");
        }
        if ((descriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        Object bean2 = this.defaultInstance(bean);
        for (int i = 0; i < descriptors.length; ++i) {
            Object value2;
            Object value;
            if (descriptors[i] instanceof IndexedPropertyDescriptor || !this.isPersistable(descriptors[i].getPropertyType()) || descriptors[i].getReadMethod() == null || descriptors[i].getWriteMethod() == null || desc.isTransientAttribute(descriptors[i].getName()) || (value = IntrospectionUtils.getProperty((Object)bean, (String)descriptors[i].getName())) == null || value.equals(value2 = IntrospectionUtils.getProperty((Object)bean2, (String)descriptors[i].getName()))) continue;
            this.printAttribute(writer, indent, bean, desc, descriptors[i].getName(), bean2, value);
        }
        if (bean instanceof ResourceBase) {
            ResourceBase resource = (ResourceBase)bean;
            Iterator iter = resource.listProperties();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = resource.getProperty(name);
                if (!this.isPersistable(value.getClass()) || desc.isTransientAttribute(name)) continue;
                this.printValue(writer, indent, name, value);
            }
        }
    }

    protected void printAttribute(PrintWriter writer, int indent, Object bean, StoreDescription desc, String attributeName, Object bean2, Object value) {
        if (this.isPrintValue(bean, bean2, attributeName, desc)) {
            this.printValue(writer, indent, attributeName, value);
        }
    }

    public boolean isPrintValue(Object bean, Object bean2, String attrName, StoreDescription desc) {
        boolean printValue = false;
        Object value = IntrospectionUtils.getProperty((Object)bean, (String)attrName);
        if (value != null) {
            Object value2 = IntrospectionUtils.getProperty((Object)bean2, (String)attrName);
            printValue = !value.equals(value2);
        }
        return printValue;
    }

    public Object defaultInstance(Object bean) throws InstantiationException, IllegalAccessException {
        return bean.getClass().newInstance();
    }

    public void printValue(PrintWriter writer, int indent, String name, Object value) {
        if (!(value instanceof String)) {
            value = value.toString();
        }
        writer.println();
        this.printIndent(writer, indent + 4);
        writer.print(name);
        writer.print("=\"");
        String strValue = this.convertStr((String)value);
        writer.print(strValue);
        writer.print("\"");
    }

    public String convertStr(String input) {
        StringBuffer filtered = new StringBuffer(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '<') {
                filtered.append("&lt;");
                continue;
            }
            if (c == '>') {
                filtered.append("&gt;");
                continue;
            }
            if (c == '\'') {
                filtered.append("&apos;");
                continue;
            }
            if (c == '\"') {
                filtered.append("&quot;");
                continue;
            }
            if (c == '&') {
                filtered.append("&amp;");
                continue;
            }
            filtered.append(c);
        }
        return filtered.toString();
    }

    protected boolean isPersistable(Class clazz) {
        for (int i = 0; i < persistables.length; ++i) {
            if (persistables[i] != clazz) continue;
            return true;
        }
        return false;
    }
}

