/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.xml.sax.Attributes;

public class DAVProppatchHandler
extends BasicDAVHandler {
    private StringBuffer myPropertyName;
    private StringBuffer myPropstatDescription;
    private StringBuffer myDescription;
    private boolean myPropstatContainsError;
    private boolean myResponseContainsError;
    private SVNErrorMessage myError;

    public static StringBuffer generatePropertyRequest(StringBuffer buffer, String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(name, value);
        return DAVProppatchHandler.generatePropertyRequest(buffer, map);
    }

    public static StringBuffer generatePropertyRequest(StringBuffer buffer, Map properties) {
        String value;
        String name;
        Iterator names;
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        buffer.append("<D:propertyupdate xmlns:D=\"DAV:\" xmlns:V=\"");
        buffer.append("http://subversion.tigris.org/xmlns/dav/");
        buffer.append("\" xmlns:C=\"");
        buffer.append("http://subversion.tigris.org/xmlns/custom/");
        buffer.append("\" xmlns:S=\"");
        buffer.append("http://subversion.tigris.org/xmlns/svn/");
        buffer.append("\" >\n");
        if (DAVProppatchHandler.hasNotNullValues(properties)) {
            buffer.append("<D:set><D:prop>\n");
            names = properties.keySet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                value = (String)properties.get(name);
                if (value == null) continue;
                buffer = DAVProppatchHandler.appendProperty(buffer, name, value);
            }
            buffer.append("\n</D:prop></D:set>");
        }
        if (DAVProppatchHandler.hasNullValues(properties)) {
            buffer.append("<D:remove><D:prop>\n");
            names = properties.keySet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                value = (String)properties.get(name);
                if (value != null) continue;
                buffer = DAVProppatchHandler.appendProperty(buffer, name, value);
            }
            buffer.append("\n</D:prop></D:remove>");
        }
        buffer.append("\n</D:propertyupdate>");
        return buffer;
    }

    private static StringBuffer appendProperty(StringBuffer buffer, String name, String value) {
        buffer.append("<");
        int index = buffer.length();
        if (name.startsWith("svn:")) {
            buffer.append("S:");
            buffer.append(name.substring("svn:".length()));
        } else {
            buffer.append("C:");
            buffer.append(name);
        }
        int index2 = buffer.length();
        if (value == null) {
            return buffer.append(" />");
        }
        if (SVNEncodingUtil.isXMLSafe(value)) {
            value = SVNEncodingUtil.xmlEncodeCDATA(value);
        } else {
            value = SVNBase64.byteArrayToBase64(value.getBytes());
            buffer.append(" V:encoding=\"base64\"");
        }
        buffer.append(">");
        buffer.append(value);
        buffer.append("</");
        buffer.append(buffer.substring(index, index2));
        return buffer.append(">");
    }

    public DAVProppatchHandler() {
        this.init();
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }

    private StringBuffer getPropertyName() {
        if (this.myPropertyName == null) {
            this.myPropertyName = new StringBuffer();
        }
        return this.myPropertyName;
    }

    private StringBuffer getPropstatDescription() {
        if (this.myPropstatDescription == null) {
            this.myPropstatDescription = new StringBuffer();
        }
        return this.myPropstatDescription;
    }

    private StringBuffer getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringBuffer();
        }
        return this.myDescription;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == DAVElement.PROP) {
            this.getPropertyName().setLength(0);
            if ("http://subversion.tigris.org/xmlns/dav/".equals(element.getNamespace())) {
                this.getPropertyName().append("svn:");
            } else if ("DAV:".equals(element.getNamespace())) {
                this.getPropertyName().append("DAV:");
            }
            this.getPropertyName().append(element.getName());
        } else if (element == DAVElement.PROPSTAT) {
            this.myPropstatContainsError = false;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        block14: {
            if (element == DAVElement.MULTISTATUS) {
                if (this.myResponseContainsError) {
                    String description = null;
                    description = this.getDescription().length() == 0 ? "The request response contained at least one error" : this.getDescription().toString();
                    this.myError = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, description);
                }
            } else if (element == DAVElement.RESPONSE_DESCRIPTION) {
                if (parent == DAVElement.PROPSTAT) {
                    this.getPropstatDescription().append(cdata);
                } else {
                    if (this.getDescription().length() != 0) {
                        this.getDescription().append('\n');
                    }
                    this.getDescription().append(cdata);
                }
            } else if (element == DAVElement.STATUS) {
                try {
                    HTTPStatus status = HTTPStatus.createHTTPStatus(cdata.toString());
                    if (parent != DAVElement.PROPSTAT) {
                        this.myResponseContainsError |= status.getCode() < 200 || status.getCode() >= 300;
                        break block14;
                    }
                    this.myPropstatContainsError = status.getCode() < 200 || status.getCode() >= 300;
                }
                catch (ParseException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The response contains a non-conforming HTTP status line"));
                }
            } else if (element == DAVElement.PROPSTAT) {
                this.myResponseContainsError |= this.myPropstatContainsError;
                this.getDescription().append("Error setting property '");
                this.getDescription().append(this.getPropertyName());
                this.getDescription().append("':");
                this.getDescription().append(this.getPropstatDescription());
            }
        }
    }

    private static boolean hasNullValues(Map map) {
        if (map.isEmpty()) {
            return false;
        }
        return map.containsValue(null);
    }

    private static boolean hasNotNullValues(Map map) {
        if (map.isEmpty()) {
            return false;
        }
        if (!DAVProppatchHandler.hasNullValues(map)) {
            return true;
        }
        Iterator entries = map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (entry.getValue() == null) continue;
            return true;
        }
        return false;
    }
}

