/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.SVNLinuxUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNWin32Util;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinCrypt;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNJNAUtil {
    private static boolean ourIsJNAPresent;
    private static final String JNA_CLASS_NAME = "com.sun.jna.Library";
    static /* synthetic */ Class class$org$tmatesoft$svn$core$internal$util$jna$SVNJNAUtil;

    public static boolean isJNAPresent() {
        return ourIsJNAPresent;
    }

    public static SVNFileType getFileType(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getFileType(file);
        }
        return null;
    }

    public static Boolean isExecutable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.isExecutable(file);
        }
        return null;
    }

    public static String getLinkTarget(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getLinkTarget(file);
        }
        return null;
    }

    public static boolean setExecutable(File file, boolean set) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.setExecutable(file, set);
        }
        return false;
    }

    public static boolean createSymlink(File file, String linkName) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.createSymlink(file, linkName);
        }
        return false;
    }

    public static boolean setWritable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNFileUtil.isWindows ? SVNWin32Util.setWritable(file) : SVNLinuxUtil.setWritable(file);
        }
        return false;
    }

    public static boolean setHidden(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.setHidden(file);
        }
        return false;
    }

    public static boolean moveFile(File src, File dst) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.moveFile(src, dst);
        }
        return false;
    }

    public static String decrypt(String encryptedData) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.decrypt(encryptedData);
        }
        return null;
    }

    public static String encrypt(String rawData) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.encrypt(rawData);
        }
        return null;
    }

    public static synchronized boolean isWinCryptEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNWinCrypt.isEnabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassLoader loader = (class$org$tmatesoft$svn$core$internal$util$jna$SVNJNAUtil == null ? (class$org$tmatesoft$svn$core$internal$util$jna$SVNJNAUtil = SVNJNAUtil.class$("org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil")) : class$org$tmatesoft$svn$core$internal$util$jna$SVNJNAUtil).getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (loader != null && loader.loadClass(JNA_CLASS_NAME) != null) {
                ourIsJNAPresent = true;
            }
        }
        catch (ClassNotFoundException e) {
            ourIsJNAPresent = false;
        }
    }
}

