/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNRemoteDiffEditor
implements ISVNEditor {
    private SVNRepository myRepos;
    private long myRevision1;
    private long myRevision2;
    private File myTarget;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsDryRun;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myEventHandler;
    private ISVNEventHandler myCancelHandler;
    private AbstractDiffCallback myDiffCallback;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private File myTempDirectory;
    private Collection myTempFiles;

    public SVNRemoteDiffEditor(SVNAdminAreaInfo info, File target, AbstractDiffCallback callback, SVNRepository repos, long revision1, long revision2, boolean dryRun, ISVNEventHandler handler, ISVNEventHandler cancelHandler) {
        this.myAdminInfo = info;
        this.myTarget = target;
        this.myDiffCallback = callback;
        this.myRepos = repos;
        this.myRevision1 = revision1;
        this.myRevision2 = revision2;
        this.myEventHandler = handler;
        this.myCancelHandler = cancelHandler;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myIsDryRun = dryRun;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myRevision2 = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(null, "", false);
        this.myCurrentDirectory.loadFromRepository();
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNStatusType type = SVNStatusType.INAPPLICABLE;
        SVNEventAction action = SVNEventAction.SKIP;
        SVNEventAction expectedAction = SVNEventAction.UPDATE_DELETE;
        SVNNodeKind nodeKind = this.myRepos.checkPath(path, this.myRevision1);
        SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myWCFile, true);
        if (this.myAdminInfo == null || dir != null) {
            if (nodeKind == SVNNodeKind.FILE) {
                SVNFileInfo file = new SVNFileInfo(path, false);
                file.loadFromRepository();
                String baseType = (String)file.myBaseProperties.get("svn:mime-type");
                type = this.getDiffCallback().fileDeleted(path, file.myBaseFile, null, baseType, null, file.myBaseProperties);
            } else if (nodeKind == SVNNodeKind.DIR) {
                type = this.getDiffCallback().directoryDeleted(path);
            }
            if (type != SVNStatusType.MISSING && type != SVNStatusType.OBSTRUCTED) {
                action = SVNEventAction.UPDATE_DELETE;
                if (this.myIsDryRun) {
                    this.getDiffCallback().addDeletedPath(path);
                }
            }
        }
        if (this.myEventHandler != null) {
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, path, action, expectedAction, type, type, nodeKind);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNEventAction expectedAction;
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myBaseProperties = Collections.EMPTY_MAP;
        SVNEventAction action = expectedAction = SVNEventAction.UPDATE_ADD;
        SVNStatusType type = this.getDiffCallback().directoryAdded(path, this.myRevision2);
        if (this.myEventHandler != null) {
            if (type == SVNStatusType.MISSING || type == SVNStatusType.OBSTRUCTED) {
                action = SVNEventAction.SKIP;
            }
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, path, action, expectedAction, type, type, SVNNodeKind.DIR);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory = new SVNDirectoryInfo(this.myCurrentDirectory, path, false);
        this.myCurrentDirectory.loadFromRepository();
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        SVNEventAction expectedAction;
        SVNStatusType type = SVNStatusType.UNKNOWN;
        SVNEventAction action = expectedAction = SVNEventAction.UPDATE_UPDATE;
        if (this.myIsDryRun) {
            this.getDiffCallback().clearDeletedPaths();
        }
        SVNAdminArea dir = null;
        if (!this.myCurrentDirectory.myPropertyDiff.isEmpty()) {
            try {
                dir = this.retrieve(this.myCurrentDirectory.myWCFile, this.myIsDryRun);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    if (this.myEventHandler != null) {
                        action = SVNEventAction.SKIP;
                        SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, this.myCurrentDirectory.myRepositoryPath, action, expectedAction, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNNodeKind.DIR);
                        this.myEventHandler.handleEvent(event, -1.0);
                    }
                    return;
                }
                throw e;
            }
            if (!this.myIsDryRun || dir != null) {
                type = this.getDiffCallback().propertiesChanged(this.myCurrentDirectory.myRepositoryPath, this.myCurrentDirectory.myBaseProperties, this.myCurrentDirectory.myPropertyDiff);
            }
        }
        if (!this.myCurrentDirectory.myIsAdded && this.myEventHandler != null) {
            if (type == SVNStatusType.UNKNOWN) {
                action = SVNEventAction.UPDATE_NONE;
            }
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, this.myCurrentDirectory.myRepositoryPath, action, expectedAction, SVNStatusType.INAPPLICABLE, type, SVNNodeKind.DIR);
            this.myEventHandler.handleEvent(event, -1.0);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(path, true);
        this.myCurrentFile.myBaseProperties = Collections.EMPTY_MAP;
        this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", false);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = new SVNFileInfo(path, false);
        this.myCurrentFile.loadFromRepository();
    }

    public void changeFileProperty(String commitPath, String name, String value) throws SVNException {
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        SVNAdminArea dir = null;
        try {
            dir = this.retrieveParent(this.myCurrentFile.myWCFile, true);
        }
        catch (SVNException e) {
            dir = null;
        }
        this.myCurrentFile.myFile = this.createTempFile(dir, SVNPathUtil.tail(commitPath));
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        SVNEventAction expectedAction;
        SVNEventAction action = expectedAction = this.myCurrentFile.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        SVNStatusType[] type = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};
        try {
            this.retrieveParent(this.myCurrentFile.myWCFile, this.myIsDryRun);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                if (this.myEventHandler != null) {
                    action = SVNEventAction.SKIP;
                    SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, commitPath, action, expectedAction, SVNStatusType.MISSING, SVNStatusType.UNKNOWN, SVNNodeKind.FILE);
                    this.myEventHandler.handleEvent(event, -1.0);
                }
                return;
            }
            throw e;
        }
        if (this.myCurrentFile.myFile != null || !this.myCurrentFile.myPropertyDiff.isEmpty()) {
            String baseMimeType = (String)this.myCurrentFile.myBaseProperties.get("svn:mime-type");
            String mimeType = (String)this.myCurrentFile.myPropertyDiff.get("svn:mime-type");
            type = this.myCurrentFile.myIsAdded ? this.getDiffCallback().fileAdded(commitPath, this.myCurrentFile.myFile != null ? this.myCurrentFile.myBaseFile : null, this.myCurrentFile.myFile, 0L, this.myRevision2, baseMimeType, mimeType, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myPropertyDiff) : this.getDiffCallback().fileChanged(commitPath, this.myCurrentFile.myFile != null ? this.myCurrentFile.myBaseFile : null, this.myCurrentFile.myFile, this.myRevision1, this.myRevision2, baseMimeType, mimeType, this.myCurrentFile.myBaseProperties, this.myCurrentFile.myPropertyDiff);
        }
        if (this.myEventHandler != null) {
            action = type[0] == SVNStatusType.MISSING || type[0] == SVNStatusType.OBSTRUCTED ? SVNEventAction.SKIP : (this.myCurrentFile.myIsAdded ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE);
            SVNEvent event = SVNEventFactory.createMergeEvent(this.myAdminInfo, commitPath, action, expectedAction, type[0], type[1], SVNNodeKind.FILE);
            this.myEventHandler.handleEvent(event, -1.0);
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void cleanup() throws SVNException {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
            this.myTempDirectory = null;
        }
        if (this.myTempFiles != null) {
            Iterator files = this.myTempFiles.iterator();
            while (files.hasNext()) {
                SVNFileUtil.deleteFile((File)files.next());
            }
        }
    }

    protected SVNAdminArea retrieve(File path, boolean lenient) throws SVNException {
        if (this.myAdminInfo == null) {
            return null;
        }
        try {
            return this.myAdminInfo.getWCAccess().retrieve(path);
        }
        catch (SVNException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected SVNAdminArea retrieveParent(File path, boolean lenient) throws SVNException {
        if (this.myAdminInfo == null) {
            return null;
        }
        return this.retrieve(path.getParentFile(), lenient);
    }

    protected AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    protected File getTempDirectory() throws SVNException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    protected File createTempFile(SVNAdminArea dir, String name) throws SVNException {
        if (dir != null && dir.isLocked()) {
            File tmpFile = dir.getBaseFile(name, true);
            if (this.myTempFiles == null) {
                this.myTempFiles = new HashSet();
            }
            this.myTempFiles.add(tmpFile);
            return tmpFile;
        }
        return SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", false);
    }

    private class SVNFileInfo {
        private String myRepositoryPath;
        private File myWCFile;
        private boolean myIsAdded;
        private File myFile;
        private File myBaseFile;
        private Map myBaseProperties;
        private Map myPropertyDiff;

        public SVNFileInfo(String path, boolean added) {
            this.myRepositoryPath = path;
            this.myIsAdded = added;
            this.myWCFile = SVNRemoteDiffEditor.this.myTarget != null ? new File(SVNRemoteDiffEditor.this.myTarget, path) : null;
            this.myPropertyDiff = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadFromRepository() throws SVNException {
            this.myBaseFile = SVNFileUtil.createUniqueFile(SVNRemoteDiffEditor.this.getTempDirectory(), ".diff", ".tmp", false);
            OutputStream os = null;
            this.myBaseProperties = new HashMap();
            try {
                os = SVNFileUtil.openFileForWriting(this.myBaseFile);
                SVNRemoteDiffEditor.this.myRepos.getFile(this.myRepositoryPath, SVNRemoteDiffEditor.this.myRevision1, this.myBaseProperties, new SVNCancellableOutputStream(os, SVNRemoteDiffEditor.this.myCancelHandler));
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
        }
    }

    private class SVNDirectoryInfo {
        private boolean myIsAdded;
        private String myRepositoryPath;
        private File myWCFile;
        private Map myBaseProperties;
        private Map myPropertyDiff;
        private SVNDirectoryInfo myParent;

        public SVNDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
            this.myParent = parent;
            this.myRepositoryPath = path;
            this.myWCFile = SVNRemoteDiffEditor.this.myTarget != null ? new File(SVNRemoteDiffEditor.this.myTarget, path) : null;
            this.myIsAdded = added;
            this.myPropertyDiff = new HashMap();
        }

        public void loadFromRepository() throws SVNException {
            this.myBaseProperties = new HashMap();
            SVNRemoteDiffEditor.this.myRepos.getDir(this.myRepositoryPath, SVNRemoteDiffEditor.this.myRevision1, this.myBaseProperties, (ISVNDirEntryHandler)null);
        }
    }
}

