/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.osuser.PrioritizedCompositePropertySet;
import com.atlassian.crowd.integration.osuser.PropertyParser;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.ProfileProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.set.ListOrderedSet;

public class DelegatingProfileProvider
implements ProfileProvider {
    private final List delegates = new ArrayList();

    public PropertySet getPropertySet(String name) {
        this.checkState();
        if (this.handles(name)) {
            ArrayList<PropertySet> propertySets = new ArrayList<PropertySet>(this.delegates.size());
            for (ProfileProvider provider : this.delegates) {
                PropertySet propertySet = provider.getPropertySet(name);
                if (propertySet == null) continue;
                propertySets.add(propertySet);
            }
            if (!propertySets.isEmpty()) {
                return new PrioritizedCompositePropertySet(propertySets);
            }
        }
        return null;
    }

    public void flushCaches() {
        this.checkState();
        for (ProfileProvider provider : this.delegates) {
            provider.flushCaches();
        }
    }

    public boolean init(Properties props) {
        List delegateDescriptors = new PropertyParser("provider-").parse(props);
        this.delegates.clear();
        for (PropertyParser.Result result : delegateDescriptors) {
            Class clazz = result.getParsedClass();
            if (!ProfileProvider.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz + " does not implement " + ProfileProvider.class);
            }
            try {
                ProfileProvider profileProvider = (ProfileProvider)clazz.newInstance();
                if (!profileProvider.init(result.getProperties())) continue;
                this.delegates.add(profileProvider);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not access configured class " + clazz + " due to " + e, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Could not find instantiate class " + clazz + " due to " + e, e);
            }
        }
        return !this.delegates.isEmpty();
    }

    public boolean create(String name) {
        this.checkState();
        ProfileProvider firstDelegate = (ProfileProvider)this.delegates.get(0);
        return firstDelegate.create(name);
    }

    public boolean handles(String name) {
        this.checkState();
        ProfileProvider firstDelegate = (ProfileProvider)this.delegates.get(0);
        return firstDelegate.handles(name);
    }

    public List list() {
        this.checkState();
        ListOrderedSet allNames = new ListOrderedSet();
        Iterator it = this.delegates.iterator();
        while (it.hasNext()) {
            List names = ((ProfileProvider)it.next()).list();
            if (names == null) continue;
            allNames.addAll(names);
        }
        return Collections.unmodifiableList(new ArrayList(allNames));
    }

    public boolean load(String name, Entity.Accessor accessor) {
        this.checkState();
        ProfileProvider firstDelegate = (ProfileProvider)this.delegates.get(0);
        return firstDelegate.load(name, accessor);
    }

    public boolean remove(String name) {
        this.checkState();
        ProfileProvider firstDelegate = (ProfileProvider)this.delegates.get(0);
        return firstDelegate.remove(name);
    }

    public boolean store(String name, Entity.Accessor accessor) {
        this.checkState();
        ProfileProvider firstDelegate = (ProfileProvider)this.delegates.get(0);
        return firstDelegate.store(name, accessor);
    }

    private void checkState() {
        if (this.delegates.isEmpty()) {
            throw new IllegalStateException("Not properly initialized. Call init() to initialize this class.");
        }
    }

    static class Property {
        static final String PREFIX = "provider-";

        Property() {
        }
    }
}

