/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.CacheFactory;
import com.atlassian.crowd.integration.service.cache.CachingGroupManager;
import com.atlassian.crowd.integration.service.cache.CachingUserManager;
import com.atlassian.crowd.integration.service.cache.GroupCache;
import com.atlassian.crowd.integration.service.cache.GroupMembershipCache;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.util.NestingHelper;
import com.atlassian.crowd.integration.util.Null;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CachingGroupMembershipManager
implements GroupMembershipManager {
    private Server server;
    private CachingGroupManager groupManager;
    private CachingUserManager userManager;

    public CachingGroupMembershipManager() {
    }

    public CachingGroupMembershipManager(SecurityServerClient ssc) {
        this.setSecurityServerClient(ssc);
    }

    private GroupMembershipCache getMembershipCache() {
        return CacheFactory.getGroupMembershipInstance();
    }

    private GroupCache getGroupCache() {
        return CacheFactory.getGroupInstance();
    }

    public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException {
        Null.not(userName);
        Null.not(groupName);
        Boolean isMember = this.getMembershipCache().isMember(userName, groupName);
        if (isMember == null) {
            isMember = this.isMemberInGroupCache(userName, groupName);
            if (isMember == null) {
                isMember = this.server.isMember(userName, groupName);
            }
            this.getMembershipCache().setMembership(userName, groupName, isMember);
        }
        return isMember;
    }

    private Boolean isMemberInGroupCache(String userName, String groupName) {
        Boolean isMember = null;
        List allUsers = this.getMembershipCache().getAllMembers(groupName);
        if (allUsers != null) {
            isMember = allUsers.contains(userName);
        }
        return isMember;
    }

    public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Null.not(userName);
        Null.not(groupName);
        this.server.addMembership(userName, groupName);
        this.getMembershipCache().setMembership(userName, groupName, Boolean.TRUE);
        this.addUserToGroup(userName, groupName);
        this.addGroupToUser(userName, groupName);
    }

    private void addGroupToUser(String userName, String groupName) {
        ArrayList<String> groups = this.getMembershipCache().getAllMemberships(userName);
        if (groups == null) {
            groups = new ArrayList<String>(1);
        }
        if (!groups.contains(userName)) {
            groups.add(groupName);
            Collections.sort(groups);
            this.getMembershipCache().addOrReplaceAllMemberships(userName, groups);
        }
    }

    private void addUserToGroup(String userName, String groupName) {
        ArrayList<String> users = this.getMembershipCache().getAllMembers(groupName);
        if (users == null) {
            users = new ArrayList<String>(1);
        }
        if (!users.contains(userName)) {
            users.add(userName);
            Collections.sort(users);
            this.getMembershipCache().addOrReplaceAllMembers(groupName, users);
        }
    }

    public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Null.not(userName);
        Null.not(groupName);
        this.server.removeMembership(userName, groupName);
        this.getMembershipCache().setMembership(userName, groupName, Boolean.FALSE);
        this.removeUserFromGroup(userName, groupName);
        this.removeGroupFromUser(userName, groupName);
    }

    private void removeGroupFromUser(String userName, String groupName) {
        List groupsForUser = this.getMembershipCache().getAllMemberships(userName);
        if (groupsForUser != null) {
            groupsForUser.remove(groupName);
        }
    }

    private void removeUserFromGroup(String userName, String groupName) {
        List usersForGroup = this.getMembershipCache().getAllMembers(groupName);
        if (usersForGroup != null) {
            usersForGroup.remove(userName);
        }
    }

    private void checkGroupRelationshipsAreCached() throws RemoteException, InvalidAuthorizationTokenException {
        if (!this.getGroupCache().containsGroupRelationships()) {
            this.groupManager.getAllGroupNames();
        }
    }

    public List getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Null.not(userName);
        List groupNames = this.getMembershipCache().getAllMemberships(userName);
        if (groupNames == null) {
            List directGroups = this.server.getMemberships(userName);
            if (directGroups != null && directGroups.size() > 0) {
                this.checkGroupRelationshipsAreCached();
            }
            groupNames = NestingHelper.getAllGroupsForUser(directGroups, this.getGroupCache());
            this.getMembershipCache().addOrReplaceAllMemberships(userName, groupNames);
        }
        if (groupNames == null || groupNames.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return groupNames;
    }

    public List getMembers(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        SOAPGroup group;
        Null.not(groupName);
        List users = this.getMembershipCache().getAllMembers(groupName);
        if (users == null && (group = this.getGroupCache().getGroup(groupName)) == null) {
            group = this.server.getGroup(groupName);
            users = this.cacheAndStripMembers(group);
            this.getGroupCache().addOrReplaceGroup(group);
        }
        if (users == null) {
            users = Collections.EMPTY_LIST;
        }
        return users;
    }

    public Boolean isUserOrGroup(String name) throws InvalidAuthorizationTokenException, RemoteException {
        Null.not(name);
        Boolean isUserOrGroup = this.getMembershipCache().isUserOrGroup(name);
        if (isUserOrGroup == null) {
            if (this.groupManager.isGroup(name) || this.userManager.isUser(name)) {
                isUserOrGroup = Boolean.TRUE;
                this.getMembershipCache().addIsUserOrGroup(name, Boolean.TRUE);
            } else {
                isUserOrGroup = Boolean.FALSE;
                this.getMembershipCache().addIsUserOrGroup(name, Boolean.FALSE);
            }
        }
        return isUserOrGroup;
    }

    protected List cacheAndStripMembers(SOAPGroup group) {
        List userNames = null;
        if (group != null) {
            String[] userArray = group.getMembers();
            userNames = this.setMembers(group.getName(), userArray);
            group.setMembers(null);
        }
        return userNames;
    }

    protected List setMembers(String groupName, String[] userNameArray) {
        Null.not(groupName);
        ArrayList<String> userNames = null;
        if (userNameArray != null && userNameArray.length > 0) {
            userNames = new ArrayList<String>(Arrays.asList(userNameArray));
            this.getMembershipCache().addOrReplaceAllMembers(groupName, userNames);
        }
        return userNames;
    }

    private void removeCachedGroup(String userName, String groupName) {
        Null.not(userName);
        Null.not(groupName);
        this.getMembershipCache().removeMembership(userName, groupName);
        this.removeGroupFromUser(userName, groupName);
    }

    protected void removeCachedGroup(String groupName) {
        Null.not(groupName);
        List userNames = this.getMembershipCache().getAllMembers(groupName);
        if (userNames != null) {
            Iterator userIt = userNames.iterator();
            while (userIt.hasNext()) {
                this.removeCachedGroup((String)userIt.next(), groupName);
            }
        }
        this.getMembershipCache().removeAllMembers(groupName);
    }

    private void removeCachedUser(String userName, String groupName) {
        Null.not(userName);
        Null.not(groupName);
        this.getMembershipCache().removeMembership(userName, groupName);
        this.removeUserFromGroup(userName, groupName);
    }

    protected void removeCachedUser(String userName) {
        Null.not(userName);
        List groups = this.getMembershipCache().getAllMemberships(userName);
        if (groups != null) {
            Iterator groupIt = groups.iterator();
            while (groupIt.hasNext()) {
                this.removeCachedUser(userName, (String)groupIt.next());
            }
        }
        this.getMembershipCache().removeAllMemberships(userName);
    }

    public void setSecurityServerClient(SecurityServerClient ssc) {
        this.server = new Server(ssc);
    }

    public void setCachingGroupManager(CachingGroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setCachingUserManager(CachingUserManager userManager) {
        this.userManager = userManager;
    }

    private static class Server {
        SecurityServerClient ssc;

        private Server(SecurityServerClient ssc) {
            this.ssc = ssc;
        }

        private SecurityServerClient getSSC() {
            return this.ssc;
        }

        public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException {
            return this.getSSC().isGroupMember(groupName, userName);
        }

        public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.getSSC().addPrincipalToGroup(userName, groupName);
        }

        public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.getSSC().removePrincipalFromGroup(userName, groupName);
        }

        public List getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            String[] groupNames = this.getSSC().findGroupMemberships(userName);
            return Arrays.asList(groupNames);
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.getSSC().findGroupByName(groupName);
        }
    }
}

