/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.grizzly;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.ws.rest.impl.http.header.HttpHeaderFactory;
import com.sun.ws.rest.spi.container.AbstractContainerRequest;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.ws.rs.core.MultivaluedMap;

public final class GrizzlyRequestAdaptor
extends AbstractContainerRequest {
    private final Request request;

    public GrizzlyRequestAdaptor(MessageBodyContext bodyContext, Request request) {
        super(bodyContext, request.method().toString(), new GrizzlyRequestInputStream(request));
        this.request = request;
        this.initiateUriInfo();
        this.copyHttpHeaders();
    }

    private void initiateUriInfo() {
        try {
            this.baseUri = new URI(this.request.scheme().toString(), null, this.request.serverName().toString(), this.request.getServerPort(), "/", null, null);
            this.completeUri = this.baseUri.resolve(this.request.unparsedURI().toString());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex);
        }
    }

    private void copyHttpHeaders() {
        MultivaluedMap<String, String> headers = this.getRequestHeaders();
        MimeHeaders mh = this.request.getMimeHeaders();
        Enumeration names = mh.names();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = mh.getHeader(name);
            headers.add((Object)name, (Object)value);
            if (!name.equalsIgnoreCase("cookie")) continue;
            this.getCookies().putAll(HttpHeaderFactory.createCookies(value));
        }
    }

    private static final class GrizzlyRequestInputStream
    extends InputStream {
        private final Request request;
        private final ByteChunk chunk;
        private ByteArrayInputStream stream;

        public GrizzlyRequestInputStream(Request request) {
            this.request = request;
            this.chunk = new ByteChunk();
        }

        public int read() throws IOException {
            this.refillIfRequired();
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            this.refillIfRequired();
            return this.stream.read(b);
        }

        private void refillIfRequired() throws IOException {
            if (this.stream == null || this.stream.available() == 0) {
                this.request.doRead(this.chunk);
                if (this.chunk.getLength() > 0) {
                    this.stream = new ByteArrayInputStream(this.chunk.getBytes(), this.chunk.getStart(), this.chunk.getLength());
                }
            }
        }
    }
}

