/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.jaxws;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.container.jaxws.MessageContextRequestAdaptor;
import com.sun.ws.rest.impl.container.jaxws.MessageContextResponseAdaptor;
import com.sun.ws.rest.spi.container.WebApplication;
import java.io.IOException;
import javax.activation.DataSource;
import javax.annotation.Resource;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BindingType(value="http://www.w3.org/2004/08/wsdl/http")
@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
public class ProviderContainer
implements Provider<DataSource> {
    @Resource
    WebServiceContext wsContext;
    private WebApplication application;

    public ProviderContainer(WebApplication application) {
        this.application = application;
    }

    public DataSource invoke(DataSource request) {
        DataSource result = null;
        MessageContext msgContext = this.wsContext.getMessageContext();
        try {
            MessageContextRequestAdaptor requestAdaptor = new MessageContextRequestAdaptor(this.application.getMessageBodyContext(), request, msgContext);
            MessageContextResponseAdaptor responseAdaptor = new MessageContextResponseAdaptor(msgContext, this.application.getMessageBodyContext(), requestAdaptor);
            this.application.handleRequest(requestAdaptor, responseAdaptor);
            result = responseAdaptor.getResultDataSource();
        }
        catch (ContainerException e) {
            throw new WebServiceException(ImplMessages.NESTED_ERROR(e.getLocalizedMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new WebServiceException(ImplMessages.NESTED_ERROR(e.getLocalizedMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new WebServiceException(ImplMessages.NESTED_ERROR(e.getLocalizedMessage()), (Throwable)e);
        }
        return result;
    }
}

