/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model;

import com.sun.ws.rest.impl.http.header.AcceptableMediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaTypeHelper {
    public static final Comparator<MediaType> MEDIA_TYPE_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (o1.getType().equals("*") && !o2.getType().equals("*")) {
                return 1;
            }
            if (o2.getType().equals("*") && !o1.getType().equals("*")) {
                return -1;
            }
            if (o1.getSubtype().equals("*") && !o2.getSubtype().equals("*")) {
                return 1;
            }
            if (o2.getSubtype().equals("*") && !o1.getSubtype().equals("*")) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<List<MediaType>> MEDIA_TYPE_LIST_COMPARATOR = new Comparator<List<MediaType>>(){

        @Override
        public int compare(List<MediaType> o1, List<MediaType> o2) {
            return MEDIA_TYPE_COMPARATOR.compare(this.getLeastSpecific(o1), this.getLeastSpecific(o2));
        }

        public MediaType getLeastSpecific(List<MediaType> l) {
            return l.get(l.size() - 1);
        }
    };
    public static final MediaType GENERAL_MEDIA_TYPE = new MediaType("*", "*");
    public static final List<MediaType> GENERAL_MEDIA_TYPE_LIST = MediaTypeHelper.createMediaTypeList();
    public static final AcceptableMediaType GENERAL_ACCEPT_MEDIA_TYPE = new AcceptableMediaType("*", "*");
    public static final List<AcceptableMediaType> GENERAL_ACCEPT_MEDIA_TYPE_LIST = MediaTypeHelper.createAcceptMediaTypeList();

    private static List<MediaType> createMediaTypeList() {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        l.add(GENERAL_MEDIA_TYPE);
        return l;
    }

    private static List<AcceptableMediaType> createAcceptMediaTypeList() {
        ArrayList<AcceptableMediaType> l = new ArrayList<AcceptableMediaType>();
        l.add(GENERAL_ACCEPT_MEDIA_TYPE);
        return l;
    }

    public static List<MediaType> createMediaTypes(ConsumeMime mime) {
        if (mime == null) {
            return GENERAL_MEDIA_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypes(mime.value());
    }

    public static List<MediaType> createMediaTypes(ProduceMime mime) {
        if (mime == null) {
            return GENERAL_MEDIA_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypes(mime.value());
    }

    public static List<MediaType> createMediaTypes(String[] mediaTypes) {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        for (String mediaType : mediaTypes) {
            l.add(MediaType.parse((String)mediaType));
        }
        Collections.sort(l, MEDIA_TYPE_COMPARATOR);
        return l;
    }
}

