/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Service;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.JAXWSMethodDispatcher;
import org.apache.cxf.jaxws.interceptors.DispatchInDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutDatabindingInterceptor;
import org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.jaxws.support.WebServiceProviderConfiguration;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsServiceFactoryBean.class);
    private AbstractServiceConfiguration jaxWsConfiguration;
    private JaxWsImplementorInfo implInfo;
    private JAXWSMethodDispatcher methodDispatcher;

    public JaxWsServiceFactoryBean() {
        this.getIgnoredClasses().add(Service.class.getName());
        this.setQualifyWrapperSchema(false);
    }

    public JaxWsServiceFactoryBean(JaxWsImplementorInfo implInfo) {
        this();
        this.implInfo = implInfo;
        this.initConfiguration(implInfo);
        this.serviceClass = implInfo.getEndpointClass();
    }

    public org.apache.cxf.service.Service create() {
        org.apache.cxf.service.Service s = super.create();
        s.put((Object)"endpoint.class", this.implInfo.getEndpointClass());
        return s;
    }

    protected Invoker createInvoker() {
        return null;
    }

    protected SimpleMethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        super.setServiceClass(serviceClass);
    }

    protected void initializeDefaultInterceptors() {
        super.initializeDefaultInterceptors();
        if (this.implInfo.isWebServiceProvider()) {
            Class<?> type = this.implInfo.getProviderParameterType();
            Service.Mode mode = this.implInfo.getServiceMode();
            this.getService().getInInterceptors().add(new DispatchInDatabindingInterceptor(type, mode));
            this.getService().getOutInterceptors().add(new DispatchOutDatabindingInterceptor(mode));
        }
    }

    protected void initializeFaultInterceptors() {
        this.getService().getOutFaultInterceptors().add(new WebFaultOutInterceptor());
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new JaxWsEndpointImpl(this.getBus(), this.getService(), ei, this.implInfo);
    }

    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method method) {
        method = ((JaxWsServiceConfiguration)this.jaxWsConfiguration).getDeclaredMethod(method);
        super.initializeWSDLOperation(intf, o, method);
        this.initializeWrapping(o, method);
        try {
            Method responseMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", method.getParameterTypes());
            List<Class<?>> asyncHandlerParams = Arrays.asList(method.getParameterTypes());
            asyncHandlerParams = new ArrayList(asyncHandlerParams);
            asyncHandlerParams.add(AsyncHandler.class);
            Method futureMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", asyncHandlerParams.toArray(new Class[asyncHandlerParams.size()]));
            this.getMethodDispatcher().bind(o, new Method[]{method, responseMethod, futureMethod});
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.getMethodDispatcher().bind(o, new Method[]{method});
        }
        Operation op = (Operation)o.getProperty(WSDLServiceBuilder.WSDL_OPERATION);
        this.initializeClassInfo(o, method, op == null ? null : CastUtils.cast((List)op.getParameterOrdering(), String.class));
    }

    protected void initializeWSDLOperations() {
        if (this.implInfo.isWebServiceProvider()) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    protected void initializeWSDLOperationsForProvider() {
        Type[] genericInterfaces = this.getServiceClass().getGenericInterfaces();
        ParameterizedType pt = (ParameterizedType)genericInterfaces[0];
        Class c = (Class)pt.getActualTypeArguments()[0];
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            for (OperationInfo o : this.getEndpointInfo().getService().getInterface().getOperations()) {
                this.getMethodDispatcher().bind(o, new Method[]{invoke});
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        for (BindingInfo bi : this.getEndpointInfo().getService().getBindings()) {
            bi.setProperty("databinding.disabled", (Object)Boolean.TRUE);
        }
    }

    void initializeWrapping(OperationInfo o, Method selected) {
        Class requestWrapper;
        Class responseWrapper = this.getResponseWrapper(selected);
        if (responseWrapper != null) {
            ((MessagePartInfo)o.getOutput().getMessageParts().get(0)).setTypeClass(responseWrapper);
        }
        if (this.getResponseWrapperClassName(selected) != null) {
            ((MessagePartInfo)o.getOutput().getMessageParts().get(0)).setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(selected));
        }
        if ((requestWrapper = this.getRequestWrapper(selected)) != null) {
            ((MessagePartInfo)o.getInput().getMessageParts().get(0)).setTypeClass(requestWrapper);
        }
        if (this.getRequestWrapperClassName(selected) != null) {
            ((MessagePartInfo)o.getInput().getMessageParts().get(0)).setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(selected));
        }
    }

    private void setFaultClassInfo(OperationInfo o, Method selected) {
        Class<?>[] types = selected.getExceptionTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> exClass = types[i];
            Class<?> beanClass = this.getBeanClass(exClass);
            QName name = this.getFaultName(o.getInterface(), o, exClass, beanClass);
            for (FaultInfo fi : o.getFaults()) {
                for (MessagePartInfo mpi : fi.getMessageParts()) {
                    String ns = null;
                    ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                    if (!mpi.getConcreteName().getLocalPart().equals(name.getLocalPart()) || !name.getNamespaceURI().equals(ns)) continue;
                    fi.setProperty(Class.class.getName(), exClass);
                    mpi.setTypeClass(beanClass);
                }
            }
        }
    }

    protected Class<?> getBeanClass(Class<?> exClass) {
        try {
            if (ServerException.class.isAssignableFrom(exClass) || RemoteException.class.isAssignableFrom(exClass)) {
                return null;
            }
            Method getFaultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.getReturnType();
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return super.getBeanClass(exClass);
        }
    }

    protected void initializeClassInfo(OperationInfo o, Method method, List<String> paramOrder) {
        if (this.isWrapped(method)) {
            MessagePartInfo part;
            MessageInfo input;
            if (o.getUnwrappedOperation() == null) {
                WSDLServiceBuilder.checkForWrapped((OperationInfo)o, (boolean)true);
            }
            if (o.hasInput()) {
                input = o.getInput();
                part = (MessagePartInfo)input.getMessageParts().get(0);
                part.setTypeClass(this.getRequestWrapper(method));
                part.setProperty("REQUEST.WRAPPER.CLASSNAME", (Object)this.getRequestWrapperClassName(method));
                part.setIndex(0);
            }
            if (o.hasOutput()) {
                input = o.getOutput();
                part = (MessagePartInfo)input.getMessageParts().get(0);
                part.setTypeClass(this.getResponseWrapper(method));
                part.setProperty("RESPONSE.WRAPPER.CLASSNAME", (Object)this.getResponseWrapperClassName(method));
                part.setIndex(0);
            }
            this.setFaultClassInfo(o, method);
            o = o.getUnwrappedOperation();
        } else if (o.isUnwrappedCapable()) {
            o.setUnwrappedOperation(null);
            this.setFaultClassInfo(o, method);
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Type genericType = genericTypes[i];
            this.initializeParameter(o, method, i, paramType, genericType);
        }
        Class<?> paramType = method.getReturnType();
        Type genericType = method.getGenericReturnType();
        this.initializeParameter(o, method, -1, paramType, genericType);
        this.setFaultClassInfo(o, method);
    }

    private void initializeParameter(OperationInfo o, Method method, int i, Class paramType, Type genericType) {
        boolean isIn = this.isInParam(method, i);
        boolean isOut = this.isOutParam(method, i);
        MessagePartInfo part = null;
        if (isIn && !isOut) {
            QName name = this.getInPartName(o, method, i);
            part = o.getInput().getMessagePart(name);
            if (part == null) {
                throw new ServiceConstructionException(new Message("COULD_NOT_FIND_PART", LOG, new Object[]{name, o.getInput().getMessagePartsMap().keySet().toString()}));
            }
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i);
        } else if (!isIn && isOut) {
            QName name = this.getOutPartName(o, method, i);
            part = o.getOutput().getMessagePart(name);
            if (part == null) {
                throw new ServiceConstructionException(new Message("COULD_NOT_FIND_PART", LOG, new Object[]{name, o.getOutput().getMessagePartsMap().keySet().toString()}));
            }
            part.setProperty("messagepart.mode.out", (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i + 1);
        } else if (isIn && isOut) {
            QName name = this.getInPartName(o, method, i);
            part = o.getInput().getMessagePart(name);
            if (part == null) {
                throw new ServiceConstructionException(new Message("COULD_NOT_FIND_PART", LOG, new Object[]{name, o.getInput().getMessagePartsMap().keySet().toString()}));
            }
            part.setProperty("messagepart.mode.inout", (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i);
            part = o.getOutput().getMessagePart(name);
            part.setProperty("messagepart.mode.inout", (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part.setIndex(i + 1);
        }
    }

    public void setJaxWsConfiguration(JaxWsServiceConfiguration jaxWsConfiguration) {
        this.jaxWsConfiguration = jaxWsConfiguration;
    }

    public JaxWsImplementorInfo getJaxWsImplementorInfo() {
        return this.implInfo;
    }

    public void setJaxWsImplementorInfo(JaxWsImplementorInfo jaxWsImplementorInfo) {
        this.implInfo = jaxWsImplementorInfo;
        this.initConfiguration(jaxWsImplementorInfo);
    }

    protected final void initConfiguration(JaxWsImplementorInfo ii) {
        if (ii.isWebServiceProvider()) {
            this.jaxWsConfiguration = new WebServiceProviderConfiguration();
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
            this.setWrapped(false);
            this.setDataBinding((DataBinding)new SourceDataBinding());
        } else {
            this.jaxWsConfiguration = new JaxWsServiceConfiguration();
            this.jaxWsConfiguration.setServiceFactory((ReflectionServiceFactoryBean)this);
            this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
        }
        this.methodDispatcher = new JAXWSMethodDispatcher(this.implInfo);
    }
}

