/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import clover.it.unimi.dsi.fastutil.chars.CharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2CharMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2CharMap
implements Long2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractLong2CharMap() {
    }

    public void setDefRetValue(char rv) {
        this.defaultReturnValue(rv);
    }

    public char getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    public char put(long key, char value) {
        throw new UnsupportedOperationException();
    }

    public char remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Character(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        char v = this.put(k, ((Character)ov).charValue());
        return this.containsKey(k) ? new Character(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        char v = this.remove(k);
        return this.containsKey(k) ? new Character(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(char v) {
        return ((CharCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2CharMap) {
            while (n-- != 0) {
                Long2CharMap.Entry e = (Long2CharMap.Entry)i.next();
                this.put(e.getLongKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2CharMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2CharMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2CharMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractLong2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2CharMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Long2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Long2CharMap.Entry first = (Long2CharMap.Entry)i.next();
            s.append(String.valueOf(first.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(first.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2CharMap.Entry {
        protected long key;
        protected char value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = ((Character)value).charValue();
        }

        public BasicEntry(long key, char value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Character(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Character(this.setValue(((Character)value).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

