/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.longs.AbstractLong2ObjectSortedMap;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import clover.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import clover.it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import clover.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Long2ObjectLinkedOpenHashMap
extends AbstractLong2ObjectSortedMap
implements Serializable,
Cloneable,
Hash,
Long2ObjectSortedMap {
    protected transient long[] key;
    protected transient Object[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient ObjectCollection values;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Long2ObjectLinkedOpenHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new long[this.free];
        this.value = new Object[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public Long2ObjectLinkedOpenHashMap(int n) {
        this(n, 0.75f);
    }

    public Long2ObjectLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2ObjectLinkedOpenHashMap(Map m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2ObjectLinkedOpenHashMap(Map m) {
        this(m, 0.75f);
    }

    public Long2ObjectLinkedOpenHashMap(Long2ObjectMap m, float f) {
        this(m.size(), f);
        this.putAll((Map)m);
    }

    public Long2ObjectLinkedOpenHashMap(Long2ObjectMap m) {
        this(m, 0.75f);
    }

    public Long2ObjectLinkedOpenHashMap(long[] k, Object[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2ObjectLinkedOpenHashMap(long[] k, Object[] v) {
        this(k, v, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] == -1 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && k != key[h1]) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(long k) {
        long[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int k2i = HashCommon.long2int(k) & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (state[h1] != 0 && k != key[h1]) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && k != key[h1]) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public Object put(long k, Object v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            Object oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        Object v = ov;
        long k = (Long)ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            Object oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public boolean containsValue(Object v) {
        Object[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == null ? v == null : value[i].equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        ObjectArrays.fill(this.value, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public long firstLongKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public long lastLongKey() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public Comparator comparator() {
        return null;
    }

    public Long2ObjectSortedMap tailMap(long from) {
        throw new UnsupportedOperationException();
    }

    public Long2ObjectSortedMap headMap(long to) {
        throw new UnsupportedOperationException();
    }

    public Long2ObjectSortedMap subMap(long from, long to) {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(long k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(long k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public Object remove(long k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        Object v = this.value[i];
        this.value[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return v;
    }

    public Object get(Object ok) {
        int i = this.findKey((Long)ok);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        Object v = this.value[i];
        this.value[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return v;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2ObjectLinkedOpenHashMap.this.findKey((Long)e.getKey());
                    return i >= 0 && (Long2ObjectLinkedOpenHashMap.this.value[i] == null ? e.getValue() == null : Long2ObjectLinkedOpenHashMap.this.value[i].equals(e.getValue()));
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Long2ObjectLinkedOpenHashMap.this.findKey((Long)e.getKey());
                    if (i >= 0) {
                        Long2ObjectLinkedOpenHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Long2ObjectLinkedOpenHashMap.this.count;
                }

                public void clear() {
                    Long2ObjectLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection(){

                public ObjectIterator objectIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Long2ObjectLinkedOpenHashMap.this.count;
                }

                public boolean contains(Object v) {
                    return Long2ObjectLinkedOpenHashMap.this.containsValue(v);
                }

                public void clear() {
                    Long2ObjectLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int n = PRIMES[newP];
        long[] lArray = this.key;
        long[] lArray2 = new long[n];
        Object[] objectArray = this.value;
        Object[] objectArray2 = new Object[n];
        byte[] byArray = this.state;
        byte[] byArray2 = new byte[n];
        int[] newN = this.link;
        int[] key = new int[n];
        this.first = -1;
        while (j-- != 0) {
            void v;
            while (byArray[i] != -1) {
                ++i;
            }
            long l = lArray[i];
            Object newValue = objectArray[i];
            int state = HashCommon.long2int(l) & Integer.MAX_VALUE;
            int newState = state % n;
            int link = state % (n - 2) + 1;
            if (v[newState] != false) {
                link = state % (n - 2) + 1;
                while (v[newState = (newState + link) % n] != false) {
                }
            }
            v[newState] = -1;
            h1[newState] = l;
            objectArray2[newState] = newValue;
            int newLink = i;
            i = newN[i] ^ prev;
            prev = newLink;
            if (this.first != -1) {
                int n2 = newPrev;
                key[n2] = key[n2] ^ newState;
                key[newState] = newPrev;
                newPrev = newState;
                continue;
            }
            newPrev = this.first = newState;
            key[newState] = -1;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = lArray2;
        this.value = objectArray2;
        this.state = byArray2;
        this.link = key;
        this.last = newPrev;
        if (newPrev != -1) {
            int n3 = newPrev;
            key[n3] = ~key[n3];
        }
    }

    public Object clone() {
        Long2ObjectLinkedOpenHashMap c;
        try {
            c = (Long2ObjectLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            j = HashCommon.long2int(this.key[t]);
            if (this != this.value[t]) {
                j ^= this.value[t] == null ? 0 : this.value[t].hashCode();
            }
            h += j;
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        Object[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeLong(key[j]);
            s.writeObject(value[j]);
        }
    }

    private void checkTable() {
        long k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        LongBidirectionalIterator i = (LongBidirectionalIterator)this.keySet().iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.nextLong();
            if (!this.containsKey(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = ((LongSortedSet)this.keySet()).iterator(this.lastLongKey());
            while (n-- != 0) {
                k = i.previousLong();
                if (!this.containsKey(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new long[n];
        long[] key = this.key;
        this.value = new Object[n];
        Object[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            long l = s.readLong();
            Object object = s.readObject();
            int n2 = HashCommon.long2int(l) & Integer.MAX_VALUE;
            int n3 = n2 % n;
            if (state[n3] != 0) {
                int v = n2 % (n - 2) + 1;
                while (state[n3 = (n3 + v) % n] != 0) {
                }
            }
            state[n3] = -1;
            key[n3] = l;
            value[n3] = object;
            if (this.first != -1) {
                int n4 = prev;
                link[n4] = link[n4] ^ n3;
                link[n3] = prev;
                prev = n3;
                continue;
            }
            prev = this.first = n3;
            link[n3] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n5 = prev;
            link[n5] = ~link[n5];
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectListIterator {
        public Object previous() {
            return Long2ObjectLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        public Object next() {
            return Long2ObjectLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        public void set(Object v) {
            throw new UnsupportedOperationException();
        }

        public void add(Object v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractLongSortedSet
    implements LongSortedSet {
        private KeySet() {
        }

        public LongBidirectionalIterator iterator(long from) {
            return new KeyIterator(from);
        }

        public LongIterator longIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Long2ObjectLinkedOpenHashMap.this.count;
        }

        public boolean contains(long k) {
            return Long2ObjectLinkedOpenHashMap.this.containsKey(k);
        }

        public boolean remove(long k) {
            int oldCount = Long2ObjectLinkedOpenHashMap.this.count;
            Long2ObjectLinkedOpenHashMap.this.remove(k);
            return Long2ObjectLinkedOpenHashMap.this.count != oldCount;
        }

        public void clear() {
            Long2ObjectLinkedOpenHashMap.this.clear();
        }

        public long firstLong() {
            if (Long2ObjectLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Long2ObjectLinkedOpenHashMap.this.key[Long2ObjectLinkedOpenHashMap.this.first];
        }

        public long lastLong() {
            if (Long2ObjectLinkedOpenHashMap.this.count == 0) {
                throw new NoSuchElementException();
            }
            return Long2ObjectLinkedOpenHashMap.this.key[Long2ObjectLinkedOpenHashMap.this.last];
        }

        public Comparator comparator() {
            return null;
        }

        public final LongSortedSet tailSet(long from) {
            throw new UnsupportedOperationException();
        }

        public final LongSortedSet headSet(long to) {
            throw new UnsupportedOperationException();
        }

        public final LongSortedSet subSet(long from, long to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongListIterator {
        public KeyIterator(long k) {
            super(k);
        }

        public long previousLong() {
            return Long2ObjectLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        public Object previous() {
            return new Long(Long2ObjectLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        public KeyIterator() {
        }

        public long nextLong() {
            return Long2ObjectLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        public Object next() {
            return new Long(Long2ObjectLinkedOpenHashMap.this.key[this.nextEntry()]);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        MapIterator() {
            this.next = Long2ObjectLinkedOpenHashMap.this.first;
        }

        MapIterator(long from) {
            if (Long2ObjectLinkedOpenHashMap.this.key[Long2ObjectLinkedOpenHashMap.this.last] == from) {
                this.prev = Long2ObjectLinkedOpenHashMap.this.last;
                this.index = Long2ObjectLinkedOpenHashMap.this.count;
            } else {
                int e;
                if (!Long2ObjectLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Long2ObjectLinkedOpenHashMap.this.first;
                while (Long2ObjectLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = Long2ObjectLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        int previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = Long2ObjectLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public Object previous() {
            return new MapEntry(this.previousEntry());
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            Long2ObjectLinkedOpenHashMap.this.state[this.curr] = 1;
            Long2ObjectLinkedOpenHashMap.this.value[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Long2ObjectLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Long2ObjectLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Long2ObjectLinkedOpenHashMap.this.count;
            if (this.prev == -1) {
                Long2ObjectLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Long2ObjectLinkedOpenHashMap.this.link[n] = Long2ObjectLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Long2ObjectLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Long2ObjectLinkedOpenHashMap.this.link[n] = Long2ObjectLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapEntry
    implements Long2ObjectMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return new Long(Long2ObjectLinkedOpenHashMap.this.key[this.index]);
        }

        public long getLongKey() {
            return Long2ObjectLinkedOpenHashMap.this.key[this.index];
        }

        public Object getValue() {
            return Long2ObjectLinkedOpenHashMap.this.value[this.index];
        }

        public Object setValue(Object v) {
            Object oldValue = Long2ObjectLinkedOpenHashMap.this.value[this.index];
            Long2ObjectLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2ObjectLinkedOpenHashMap.this.key[this.index] == (Long)e.getKey() && (Long2ObjectLinkedOpenHashMap.this.value[this.index] == null ? e.getValue() == null : Long2ObjectLinkedOpenHashMap.this.value[this.index].equals(e.getValue()));
        }

        public int hashCode() {
            return HashCommon.long2int(Long2ObjectLinkedOpenHashMap.this.key[this.index]) ^ (Long2ObjectLinkedOpenHashMap.this.value[this.index] == null ? 0 : Long2ObjectLinkedOpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Long2ObjectLinkedOpenHashMap.this.key[this.index] + "->" + Long2ObjectLinkedOpenHashMap.this.value[this.index];
        }
    }
}

