/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.LegendItem;
import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.CategoryItemEntity;
import clover.org.jfree.chart.entity.ChartEntity;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.CategoryToolTipGenerator;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.renderer.Outlier;
import clover.org.jfree.chart.renderer.OutlierList;
import clover.org.jfree.chart.renderer.OutlierListCollection;
import clover.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PaintUtilities;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 632027470694481177L;
    private transient Paint artifactPaint = Color.black;
    private boolean fillBox = true;
    private double itemMargin = 0.2;

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.artifactPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean flag) {
        this.fillBox = flag;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double margin) {
        this.itemMargin = margin;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot cp = this.getPlot();
        if (cp == null) {
            return null;
        }
        if (!this.isSeriesVisible(series) || !this.isSeriesVisibleInLegend(series)) {
            return null;
        }
        CategoryDataset dataset = cp.getDataset(datasetIndex);
        String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
        String toolTipText = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            toolTipText = this.getLegendItemToolTipGenerator().generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.getLegendItemURLGenerator() != null) {
            urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
        }
        Rectangle2D.Double shape = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        Paint paint = this.lookupSeriesPaint(series);
        Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
        Stroke outlineStroke = this.lookupSeriesOutlineStroke(series);
        LegendItem result = new LegendItem(label, description, toolTipText, urlText, (Shape)shape, paint, outlineStroke, outlinePaint);
        result.setDataset(dataset);
        result.setDatasetIndex(datasetIndex);
        result.setSeriesKey(dataset.getRowKey(series));
        result.setSeriesIndex(series);
        return result;
    }

    public CategoryItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        CategoryItemRendererState state = super.initialise(g2, dataArea, plot, rendererIndex, info);
        CategoryAxis domainAxis = this.getDomainAxis(plot, rendererIndex);
        CategoryDataset dataset = plot.getDataset(rendererIndex);
        if (dataset != null) {
            int columns = dataset.getColumnCount();
            int rows = dataset.getRowCount();
            double space = 0.0;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                space = dataArea.getHeight();
            } else if (orientation == PlotOrientation.VERTICAL) {
                space = dataArea.getWidth();
            }
            double categoryMargin = 0.0;
            double currentItemMargin = 0.0;
            if (columns > 1) {
                categoryMargin = domainAxis.getCategoryMargin();
            }
            if (rows > 1) {
                currentItemMargin = this.getItemMargin();
            }
            double used = space * (1.0 - domainAxis.getLowerMargin() - domainAxis.getUpperMargin() - categoryMargin - currentItemMargin);
            if (rows * columns > 0) {
                state.setBarWidth(used / (double)(dataset.getColumnCount() * dataset.getRowCount()));
            } else {
                state.setBarWidth(used);
            }
        }
        return state;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (!(dataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column);
        } else if (orientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawHorizontalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entityCollection;
        void avgEllipse;
        Number number;
        Object object;
        double d;
        double d2;
        BoxAndWhiskerCategoryDataset bawDataset = (BoxAndWhiskerCategoryDataset)dataset;
        double categoryEnd = domainAxis.getCategoryEnd(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryStart = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryWidth = Math.abs(categoryEnd - categoryStart);
        double yy = categoryStart;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double usedWidth = state.getBarWidth() * (double)seriesCount + seriesGap * (double)(seriesCount - 1);
            double offset = (categoryWidth - usedWidth) / 2.0;
            yy = yy + offset + (double)row * (state.getBarWidth() + seriesGap);
        } else {
            double offset = (categoryWidth - state.getBarWidth()) / 2.0;
            yy += offset;
        }
        Paint paint = this.getItemPaint(row, column);
        if (paint != null) {
            g2.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(row, column);
        g2.setStroke(stroke);
        RectangleEdge rectangleEdge = plot.getRangeAxisEdge();
        Number number2 = bawDataset.getQ1Value(row, column);
        Number number3 = bawDataset.getQ3Value(row, column);
        Number number4 = bawDataset.getMaxRegularValue(row, column);
        Number number5 = bawDataset.getMinRegularValue(row, column);
        Rectangle2D.Double double_ = null;
        if (number2 != null && number3 != null && number4 != null && number5 != null) {
            void xxMin;
            void yymid;
            d2 = rangeAxis.valueToJava2D(number2.doubleValue(), dataArea, rectangleEdge);
            double d3 = rangeAxis.valueToJava2D(number3.doubleValue(), dataArea, rectangleEdge);
            d = rangeAxis.valueToJava2D(number4.doubleValue(), dataArea, rectangleEdge);
            double d4 = rangeAxis.valueToJava2D(number5.doubleValue(), dataArea, rectangleEdge);
            double d5 = yy + state.getBarWidth() / 2.0;
            g2.draw(new Line2D.Double(d, d5, (double)yymid, d5));
            g2.draw(new Line2D.Double(d, yy, d, yy + state.getBarWidth()));
            g2.draw(new Line2D.Double(d4, d5, (double)xxMin, d5));
            g2.draw(new Line2D.Double(d4, yy, d4, yy + state.getBarWidth()));
            double_ = new Rectangle2D.Double(Math.min((double)xxMin, (double)yymid), yy, Math.abs((double)(xxMin - yymid)), state.getBarWidth());
            if (this.fillBox) {
                g2.fill(double_);
            }
            g2.draw(double_);
        }
        g2.setPaint(this.artifactPaint);
        d2 = 0.0;
        Number number6 = bawDataset.getMeanValue(row, column);
        if (number6 != null) {
            double d6 = rangeAxis.valueToJava2D(number6.doubleValue(), dataArea, rectangleEdge);
            d2 = state.getBarWidth() / 4.0;
            object = new Ellipse2D.Double(d6 - d2, yy + d2, d2 * 2.0, d2 * 2.0);
            g2.fill((Shape)object);
            g2.draw((Shape)object);
        }
        if ((number = bawDataset.getMedianValue(row, column)) != null) {
            d = rangeAxis.valueToJava2D(number.doubleValue(), dataArea, rectangleEdge);
            g2.draw(new Line2D.Double(d, yy, d, yy + state.getBarWidth()));
        }
        if (state.getInfo() != null && avgEllipse != null && (entityCollection = state.getEntityCollection()) != null) {
            void tip;
            object = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(row, column);
            if (categoryToolTipGenerator != null) {
                object = categoryToolTipGenerator.generateToolTip(dataset, row, column);
            }
            String string = null;
            if (this.getItemURLGenerator(row, column) != null) {
                string = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity((Shape)tip, (String)object, string, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            entityCollection.add(categoryItemEntity);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawVerticalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        void yMedian;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Serializable serializable2;
        double yyMax;
        double yyMin;
        double d;
        void yQ3;
        void box;
        void yMin;
        void yMax;
        BoxAndWhiskerCategoryDataset bawDataset = (BoxAndWhiskerCategoryDataset)dataset;
        double categoryEnd = domainAxis.getCategoryEnd(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryStart = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double categoryWidth = categoryEnd - categoryStart;
        double xx = categoryStart;
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double usedWidth = state.getBarWidth() * (double)seriesCount + seriesGap * (double)(seriesCount - 1);
            double offset = (categoryWidth - usedWidth) / 2.0;
            xx = xx + offset + (double)row * (state.getBarWidth() + seriesGap);
        } else {
            double offset = (categoryWidth - state.getBarWidth()) / 2.0;
            xx += offset;
        }
        double yyAverage = 0.0;
        Paint paint = this.getItemPaint(row, column);
        if (paint != null) {
            g2.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(row, column);
        g2.setStroke(stroke);
        double d2 = 0.0;
        RectangleEdge rectangleEdge = plot.getRangeAxisEdge();
        Number number = bawDataset.getQ1Value(row, column);
        Number number2 = bawDataset.getQ3Value(row, column);
        Number number3 = bawDataset.getMaxRegularValue(row, column);
        Number number4 = bawDataset.getMinRegularValue(row, column);
        Rectangle2D.Double double_ = null;
        if (yMax != null && yMin != null && box != null && number4 != null) {
            void yyQ3;
            void xxmid;
            double d3 = rangeAxis.valueToJava2D(yMax.doubleValue(), dataArea, (RectangleEdge)yQ3);
            double d4 = rangeAxis.valueToJava2D(yMin.doubleValue(), dataArea, (RectangleEdge)yQ3);
            double d5 = rangeAxis.valueToJava2D(box.doubleValue(), dataArea, (RectangleEdge)yQ3);
            d = rangeAxis.valueToJava2D(number4.doubleValue(), dataArea, (RectangleEdge)yQ3);
            double d6 = xx + state.getBarWidth() / 2.0;
            g2.draw(new Line2D.Double(d6, yyMin, d6, yyMax));
            g2.draw(new Line2D.Double(xx, yyMin, xx + state.getBarWidth(), yyMin));
            g2.draw(new Line2D.Double(d6, (double)xxmid, d6, (double)yyQ3));
            g2.draw(new Line2D.Double(xx, (double)xxmid, xx + state.getBarWidth(), (double)xxmid));
            double_ = new Rectangle2D.Double(xx, Math.min((double)yyQ3, yyMax), state.getBarWidth(), Math.abs((double)(yyQ3 - yyMax)));
            if (this.fillBox) {
                g2.fill(double_);
            }
            g2.draw(double_);
        }
        g2.setPaint(this.artifactPaint);
        Number number5 = bawDataset.getMeanValue(row, column);
        if (number5 != null) {
            yyAverage = rangeAxis.valueToJava2D(number5.doubleValue(), dataArea, (RectangleEdge)yQ3);
            d2 = state.getBarWidth() / 4.0;
            serializable2 = new Ellipse2D.Double(xx + d2, yyAverage - d2, d2 * 2.0, d2 * 2.0);
            g2.fill((Shape)((Object)serializable2));
            g2.draw((Shape)((Object)serializable2));
        }
        if ((serializable2 = bawDataset.getMedianValue(row, column)) != null) {
            yyMax = rangeAxis.valueToJava2D(serializable2.doubleValue(), dataArea, (RectangleEdge)yQ3);
            g2.draw(new Line2D.Double(xx, yyMax, xx + state.getBarWidth(), yyMax));
        }
        yyMax = rangeAxis.valueToJava2D(rangeAxis.getUpperBound(), dataArea, (RectangleEdge)yQ3) + d2;
        yyMin = rangeAxis.valueToJava2D(rangeAxis.getLowerBound(), dataArea, (RectangleEdge)yQ3) - d2;
        g2.setPaint(paint);
        d = state.getBarWidth() / 3.0;
        ArrayList arrayList = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = bawDataset.getOutliers(row, column);
        if (list != null) {
            void minOutlier;
            void maxOutlier;
            for (int i = 0; i < list.size(); ++i) {
                double yyOutlier;
                double d7 = ((Number)list.get(i)).doubleValue();
                object4 = bawDataset.getMinOutlier(row, column);
                serializable = bawDataset.getMaxOutlier(row, column);
                Number number6 = bawDataset.getMinRegularValue(row, column);
                Number number7 = bawDataset.getMaxRegularValue(row, column);
                if (d7 > serializable.doubleValue()) {
                    maxOutlier.setHighFarOut(true);
                } else if (d7 < ((Number)object4).doubleValue()) {
                    maxOutlier.setLowFarOut(true);
                } else if (d7 > number7.doubleValue()) {
                    yyOutlier = rangeAxis.valueToJava2D(d7, dataArea, (RectangleEdge)yQ3);
                    minOutlier.add(new Outlier(xx + state.getBarWidth() / 2.0, yyOutlier, d));
                } else if (d7 < number6.doubleValue()) {
                    yyOutlier = rangeAxis.valueToJava2D(d7, dataArea, (RectangleEdge)yQ3);
                    minOutlier.add(new Outlier(xx + state.getBarWidth() / 2.0, yyOutlier, d));
                }
                Collections.sort(minOutlier);
            }
            object3 = minOutlier.iterator();
            while (object3.hasNext()) {
                object2 = (Outlier)object3.next();
                maxOutlier.add((Outlier)object2);
            }
            object3 = maxOutlier.iterator();
            while (object3.hasNext()) {
                object2 = (OutlierList)object3.next();
                object = ((OutlierList)object2).getAveragedOutlier();
                object4 = ((Outlier)object).getPoint();
                if (((OutlierList)object2).isMultiple()) {
                    this.drawMultipleEllipse((Point2D)object4, state.getBarWidth(), d, g2);
                    continue;
                }
                this.drawEllipse((Point2D)object4, d, g2);
            }
            if (maxOutlier.isHighFarOut()) {
                void minAxisValue;
                this.drawHighFarOut(d2 / 2.0, g2, xx + state.getBarWidth() / 2.0, (double)minAxisValue);
            }
            if (maxOutlier.isLowFarOut()) {
                void oRadius;
                this.drawLowFarOut(d2 / 2.0, g2, xx + state.getBarWidth() / 2.0, (double)oRadius);
            }
        }
        if (state.getInfo() != null && yMedian != null && (object3 = state.getEntityCollection()) != null) {
            object2 = null;
            object = this.getToolTipGenerator(row, column);
            if (object != null) {
                object2 = object.generateToolTip(dataset, row, column);
            }
            object4 = null;
            if (this.getItemURLGenerator(row, column) != null) {
                object4 = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            serializable = new CategoryItemEntity((Shape)yMedian, (String)object2, (String)object4, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            object3.add((ChartEntity)serializable);
        }
    }

    private void drawEllipse(Point2D point, double oRadius, Graphics2D g2) {
        Ellipse2D.Double dot = new Ellipse2D.Double(point.getX() + oRadius / 2.0, point.getY(), oRadius, oRadius);
        g2.draw(dot);
    }

    private void drawMultipleEllipse(Point2D point, double boxWidth, double oRadius, Graphics2D g2) {
        Ellipse2D.Double dot1 = new Ellipse2D.Double(point.getX() - boxWidth / 2.0 + oRadius, point.getY(), oRadius, oRadius);
        Ellipse2D.Double dot2 = new Ellipse2D.Double(point.getX() + boxWidth / 2.0, point.getY(), oRadius, oRadius);
        g2.draw(dot1);
        g2.draw(dot2);
    }

    private void drawHighFarOut(double aRadius, Graphics2D g2, double xx, double m) {
        double side = aRadius * 2.0;
        g2.draw(new Line2D.Double(xx - side, m + side, xx + side, m + side));
        g2.draw(new Line2D.Double(xx - side, m + side, xx, m));
        g2.draw(new Line2D.Double(xx + side, m + side, xx, m));
    }

    private void drawLowFarOut(double aRadius, Graphics2D g2, double xx, double m) {
        double side = aRadius * 2.0;
        g2.draw(new Line2D.Double(xx - side, m - side, xx + side, m - side));
        g2.draw(new Line2D.Double(xx - side, m - side, xx, m));
        g2.draw(new Line2D.Double(xx + side, m - side, xx, m));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BoxAndWhiskerRenderer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BoxAndWhiskerRenderer that = (BoxAndWhiskerRenderer)obj;
        if (!PaintUtilities.equal(this.artifactPaint, that.artifactPaint)) {
            return false;
        }
        if (this.fillBox != that.fillBox) {
            return false;
        }
        return this.itemMargin == that.itemMargin;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.artifactPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.artifactPaint = SerialUtilities.readPaint(stream);
    }
}

