/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.CategoryItemLabelGenerator;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.renderer.category.BarRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.statistics.StatisticalCategoryDataset;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.GradientPaintTransformer;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.ObjectUtilities;
import clover.org.jfree.util.PaintUtilities;
import clover.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StatisticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4986038395414039117L;
    private transient Paint errorIndicatorPaint = Color.gray;
    private transient Stroke errorIndicatorStroke = new BasicStroke(1.0f);

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        this.errorIndicatorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorIndicatorStroke() {
        return this.errorIndicatorStroke;
    }

    public void setErrorIndicatorStroke(Stroke stroke) {
        this.errorIndicatorStroke = stroke;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset data, int row, int column, int pass) {
        if (!(data instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("Requires StatisticalCategoryDataset.");
        }
        StatisticalCategoryDataset statData = (StatisticalCategoryDataset)data;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(g2, state, dataArea, plot, domainAxis, rangeAxis, statData, row, column);
        } else if (orientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(g2, state, dataArea, plot, domainAxis, rangeAxis, statData, row, column);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawHorizontalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, StatisticalCategoryDataset dataset, int row, int column) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        void t;
        void rectWidth;
        void rectHeight;
        void rectX;
        void transY2;
        void uclip;
        double lclip;
        double base;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        double rectY = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, xAxisLocation);
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getHeight() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            rectY += (double)row * (state.getBarWidth() + seriesGap);
        } else {
            rectY += (double)row * state.getBarWidth();
        }
        Number number = dataset.getMeanValue(row, column);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = this.getLowerClip();
        double d4 = this.getUpperClip();
        if (d4 <= 0.0) {
            if (base >= d4) {
                return;
            }
            lclip = d4;
            if (base <= uclip) {
                base = uclip;
            }
        } else if (uclip <= 0.0) {
            if (base >= d4) {
                base = d4;
            } else if (base <= uclip) {
                base = uclip;
            }
        } else {
            if (base <= uclip) {
                return;
            }
            lclip = this.getLowerClip();
            if (base >= d4) {
                base = d4;
            }
        }
        RectangleEdge rectangleEdge = plot.getRangeAxisEdge();
        double d5 = rangeAxis.valueToJava2D(lclip, dataArea, rectangleEdge);
        double d6 = rangeAxis.valueToJava2D(base, dataArea, rectangleEdge);
        double d7 = Math.min(d6, (double)transY2);
        double d8 = state.getBarWidth();
        double d9 = Math.abs((double)(rectX - transY2));
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)rectHeight, rectY, d9, (double)rectWidth);
        Paint paint = this.getItemPaint(row, column);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)t);
        }
        g2.setPaint(paint);
        g2.fill((Shape)t);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(row, column);
            object = this.getItemOutlinePaint(row, column);
            if (object2 != null && object != null) {
                g2.setStroke((Stroke)object2);
                g2.setPaint((Paint)object);
                g2.draw((Shape)t);
            }
        }
        if ((object2 = dataset.getStdDevValue(row, column)) != null) {
            double d10 = ((Number)object2).doubleValue();
            double d11 = rangeAxis.valueToJava2D(number.doubleValue() + d10, dataArea, rectangleEdge);
            double d12 = rangeAxis.valueToJava2D(number.doubleValue() - d10, dataArea, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                g2.setPaint(this.errorIndicatorPaint);
            } else {
                g2.setPaint(this.getItemOutlinePaint(row, column));
            }
            if (this.errorIndicatorStroke != null) {
                g2.setStroke(this.errorIndicatorStroke);
            } else {
                g2.setStroke(this.getItemOutlineStroke(row, column));
            }
            Line2D.Double double_2 = null;
            double_2 = new Line2D.Double(d12, rectY + rectWidth / 2.0, d11, rectY + rectWidth / 2.0);
            g2.draw(double_2);
            double_2 = new Line2D.Double(d11, rectY + rectWidth * 0.25, d11, rectY + rectWidth * 0.75);
            g2.draw(double_2);
            double_2 = new Line2D.Double(d12, rectY + rectWidth * 0.25, d12, rectY + rectWidth * 0.75);
            g2.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, (CategoryItemLabelGenerator)object, (Rectangle2D)t, base < 0.0);
        }
        if ((entityCollection = state.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, dataset, row, column, (Shape)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawVerticalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, StatisticalCategoryDataset dataset, int row, int column) {
        EntityCollection entityCollection;
        Object object;
        Object object2;
        void t;
        void rectHeight;
        void rectWidth;
        void rectY;
        void transY2;
        void uclip;
        double lclip;
        double base;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        double rectX = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, xAxisLocation);
        int seriesCount = this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = dataArea.getWidth() * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            rectX += (double)row * (state.getBarWidth() + seriesGap);
        } else {
            rectX += (double)row * state.getBarWidth();
        }
        Number number = dataset.getMeanValue(row, column);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = this.getLowerClip();
        double d4 = this.getUpperClip();
        if (d4 <= 0.0) {
            if (base >= d4) {
                return;
            }
            lclip = d4;
            if (base <= uclip) {
                base = uclip;
            }
        } else if (uclip <= 0.0) {
            if (base >= d4) {
                base = d4;
            } else if (base <= uclip) {
                base = uclip;
            }
        } else {
            if (base <= uclip) {
                return;
            }
            lclip = this.getLowerClip();
            if (base >= d4) {
                base = d4;
            }
        }
        RectangleEdge rectangleEdge = plot.getRangeAxisEdge();
        double d5 = rangeAxis.valueToJava2D(lclip, dataArea, rectangleEdge);
        double d6 = rangeAxis.valueToJava2D(base, dataArea, rectangleEdge);
        double d7 = Math.min(d6, (double)transY2);
        double d8 = state.getBarWidth();
        double d9 = Math.abs((double)(rectY - transY2));
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectX, (double)rectWidth, (double)rectHeight, d9);
        Paint paint = this.getItemPaint(row, column);
        GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)t);
        }
        g2.setPaint(paint);
        g2.fill((Shape)t);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(row, column);
            object = this.getItemOutlinePaint(row, column);
            if (object2 != null && object != null) {
                g2.setStroke((Stroke)object2);
                g2.setPaint((Paint)object);
                g2.draw((Shape)t);
            }
        }
        if ((object2 = dataset.getStdDevValue(row, column)) != null) {
            double d10 = ((Number)object2).doubleValue();
            double d11 = rangeAxis.valueToJava2D(number.doubleValue() + d10, dataArea, rectangleEdge);
            double d12 = rangeAxis.valueToJava2D(number.doubleValue() - d10, dataArea, rectangleEdge);
            if (this.errorIndicatorPaint != null) {
                g2.setPaint(this.errorIndicatorPaint);
            } else {
                g2.setPaint(this.getItemOutlinePaint(row, column));
            }
            if (this.errorIndicatorStroke != null) {
                g2.setStroke(this.errorIndicatorStroke);
            } else {
                g2.setStroke(this.getItemOutlineStroke(row, column));
            }
            Line2D.Double double_2 = null;
            double_2 = new Line2D.Double(rectX + rectHeight / 2.0, d12, rectX + rectHeight / 2.0, d11);
            g2.draw(double_2);
            double_2 = new Line2D.Double(rectX + rectHeight / 2.0 - 5.0, d11, rectX + rectHeight / 2.0 + 5.0, d11);
            g2.draw(double_2);
            double_2 = new Line2D.Double(rectX + rectHeight / 2.0 - 5.0, d12, rectX + rectHeight / 2.0 + 5.0, d12);
            g2.draw(double_2);
        }
        if ((object = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, (CategoryItemLabelGenerator)object, (Rectangle2D)t, base < 0.0);
        }
        if ((entityCollection = state.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, dataset, row, column, (Shape)t);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StatisticalBarRenderer)) {
            return false;
        }
        StatisticalBarRenderer that = (StatisticalBarRenderer)obj;
        if (!PaintUtilities.equal(this.errorIndicatorPaint, that.errorIndicatorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorIndicatorStroke, that.errorIndicatorStroke)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorIndicatorPaint, stream);
        SerialUtilities.writeStroke(this.errorIndicatorStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.errorIndicatorPaint = SerialUtilities.readPaint(stream);
        this.errorIndicatorStroke = SerialUtilities.readStroke(stream);
    }
}

