/*
 * Decompiled with CFR 0.152.
 */
package clover_cenqua_com.atlassian.license;

import clover_cenqua_com.atlassian.license.LicenseException;
import clover_cenqua_com.atlassian.license.LicenseUtils;
import java.util.StringTokenizer;

public class LicensePair {
    private byte[] license;
    private byte[] hash;
    private String originalLicenseString;

    public LicensePair(byte[] license, byte[] hash) throws LicenseException {
        this.license = license;
        this.hash = hash;
        this.originalLicenseString = LicenseUtils.getString(hash) + LicenseUtils.getString(license);
    }

    public LicensePair(String license, String hash) throws LicenseException {
        if (license == null || hash == null) {
            throw new LicenseException("License string or hash are null.");
        }
        try {
            this.originalLicenseString = hash + license;
            this.license = LicenseUtils.getBytes(license);
            this.hash = LicenseUtils.getBytes(hash);
        }
        catch (Exception e) {
            throw new LicenseException("Exception generating license: " + e);
        }
    }

    public LicensePair(String concatLicense) throws LicenseException {
        if (concatLicense == null) {
            throw new LicenseException("contactLicense was null");
        }
        StringTokenizer tokenizer = new StringTokenizer(concatLicense, " \n\t\r");
        if (tokenizer.countTokens() < 3) {
            throw new LicenseException("License string is too short.");
        }
        String hash = tokenizer.nextToken() + tokenizer.nextToken();
        String license = "";
        while (tokenizer.hasMoreTokens()) {
            license = license + tokenizer.nextToken();
        }
        try {
            this.originalLicenseString = concatLicense;
            this.license = LicenseUtils.getBytes(license);
            this.hash = LicenseUtils.getBytes(hash);
        }
        catch (Exception e) {
            throw new LicenseException("Exception generating license: " + e);
        }
    }

    public byte[] getLicense() {
        return this.license;
    }

    public String getLicenseString() {
        return LicenseUtils.getString(this.license);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getHashString() {
        return LicenseUtils.getString(this.hash);
    }

    public String getOriginalLicenseString() {
        return this.originalLicenseString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String hash = this.getHashString();
        int lineLength = hash.length() / 2;
        while (hash.length() > lineLength) {
            sb.append(hash.substring(0, lineLength));
            sb.append("\n");
            hash = hash.substring(lineLength);
        }
        sb.append(hash);
        sb.append("\n");
        String license = this.getLicenseString();
        while (license.length() > lineLength) {
            sb.append(license.substring(0, lineLength));
            sb.append("\n");
            license = license.substring(lineLength);
        }
        sb.append(license);
        sb.append("\n");
        return sb.toString();
    }
}

