/*
 * Decompiled with CFR 0.152.
 */
package cloverantlr;

import cloverantlr.FileLineFormatter;
import cloverantlr.RecognitionException;
import cloverantlr.Token;
import cloverantlr.TreeParser;
import cloverantlr.collections.AST;

public class NoViableAltException
extends RecognitionException {
    public Token token;
    public AST node;

    public NoViableAltException(AST t) {
        super("NoViableAlt");
        this.node = t;
        this.fileName = "<AST>";
    }

    public NoViableAltException(Token t, String fileName) {
        super("NoViableAlt");
        this.token = t;
        this.line = t.getLine();
        this.column = t.getColumn();
        this.fileName = fileName;
    }

    public String getErrorMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        if (this.token != null) {
            return "unexpected token: " + this.token.getText();
        }
        if (this.node == TreeParser.ASTNULL) {
            return "unexpected end of subtree";
        }
        return "unexpected AST node: " + ((Object)this.node).toString();
    }

    public String toString() {
        if (this.token != null) {
            return FileLineFormatter.getFormatter().getFormatString(this.fileName, this.line) + this.getMessage();
        }
        return this.getMessage();
    }
}

