/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.util.ChecksummingReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtils {
    public static final long PLATFORM_FS_RESOLUTION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dest) throws IOException {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dest));
            int b = ((InputStream)in).read();
            while (b >= 0) {
                ((OutputStream)out).write(b);
                b = ((InputStream)in).read();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(in);
        FileUtils.close(out);
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean deltree(File f) {
        if (f.isDirectory()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                if (FileUtils.deltree(new File(f, files[i]))) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static String getNormalizedPath(File f) {
        return FileUtils.getNormalizedPath(f.getAbsolutePath());
    }

    public static String getNormalizedPath(String p) {
        return p.replace('\\', '/');
    }

    public static String getRelativePath(String a, String b) {
        String[] pathA = FileUtils.getPaths(a);
        String[] pathB = FileUtils.getPaths(b);
        int indexA = -1;
        int indexB = -1;
        for (int i = pathA.length; 0 < i; --i) {
            if (FileUtils.lastIndexOf(pathA[i - 1], pathB) == -1) continue;
            indexA = i - 1;
            indexB = FileUtils.lastIndexOf(pathA[i - 1], pathB);
            break;
        }
        if (indexA == -1 || indexB == -1) {
            return null;
        }
        int pathADistance = pathA.length - (indexA + 1);
        int pathBDistance = pathB.length - (indexB + 1);
        String relativePath = "";
        for (int i = 0; i < pathADistance; ++i) {
            relativePath = relativePath + ".." + File.separator;
        }
        String[] pathBComponents = FileUtils.getPathComponents(b);
        String sep = "";
        for (int i = pathB.length - pathBDistance; i < pathB.length; ++i) {
            relativePath = relativePath + sep + pathBComponents[i];
            sep = File.separator;
        }
        return relativePath;
    }

    public static String getRelativePath(File a, File b) {
        return FileUtils.getRelativePath(a.getAbsolutePath(), b.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calcAdlerChecksum(File f, String encoding) throws IOException {
        long l;
        char[] buffer = new char[8192];
        ChecksummingReader reader = null;
        try {
            InputStreamReader in = encoding != null ? new InputStreamReader((InputStream)new FileInputStream(f), encoding) : new FileReader(f);
            reader = new ChecksummingReader(new BufferedReader(in));
            while (reader.read(buffer) >= 0) {
            }
            l = reader.getChecksum();
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            throw throwable;
        }
        FileUtils.close(reader);
        return l;
    }

    private static int lastIndexOf(String str, String[] path) {
        for (int i = path.length; 0 < i; --i) {
            if (path[i - 1].compareTo(str) != 0) continue;
            return i - 1;
        }
        return -1;
    }

    private static String[] getPathComponents(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tokens.nextToken();
        }
        return result;
    }

    private static String[] getPaths(String str) {
        StringTokenizer tokens = new StringTokenizer(str, "\\/", false);
        String[] result = new String[tokens.countTokens()];
        String currentPath = "";
        String pathSep = "";
        for (int i = 0; i < result.length; ++i) {
            result[i] = currentPath = currentPath + pathSep + tokens.nextToken();
            pathSep = File.separator;
        }
        return result;
    }

    public static boolean isAncestorOf(File a, File b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        for (File ancestor = b.getParentFile(); ancestor != null; ancestor = ancestor.getParentFile()) {
            if (!ancestor.equals(a)) continue;
            return true;
        }
        return false;
    }

    public static String fromURI(String uri) {
        if (!uri.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        uri = uri.startsWith("file://") ? uri.substring(7) : uri.substring(5);
        uri = uri.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c2 = iter.next();
                    if (c2 != '\uffff') {
                        int i2 = Character.digit(c2, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c);
            }
            c = iter.next();
        }
        return sb.toString();
    }

    public static OutputStream createGZipOutputStream(String aFile) throws IOException {
        return FileUtils.createGZipOutputStream(new File(aFile));
    }

    public static OutputStream createGZipOutputStream(File aFile) throws IOException {
        return new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(aFile))));
    }

    public static InputStream createGZipInputStream(File aInfile) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(aInfile))));
    }

    public static int compareLastModified(long date, File file) {
        return FileUtils.compareLastModified(date, file.lastModified());
    }

    public static int compareLastModified(long date1, long date2) {
        long diff = date1 - date2;
        if (Math.abs(diff) <= PLATFORM_FS_RESOLUTION / 2L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }

    public static File[] listMatchingFilesForDir(File dir, final String regex) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().matches(regex);
            }
        });
        if (files == null) {
            throw new IOException("Unable to read directory " + dir);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int rez;
        File temp = null;
        try {
            temp = File.createTempFile("clover_fs_rez_test", "txt");
            for (rez = 1; rez <= 1000; rez *= 10) {
                temp.setLastModified(rez);
                if (temp.lastModified() != (long)rez) continue;
                break;
            }
        }
        catch (IOException e) {
            rez = 1000;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        PLATFORM_FS_RESOLUTION = rez;
    }
}

