/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.Logger;
import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class UnicodeDecodingReader
extends FilterReader {
    private Logger log = Logger.getInstance();
    private int leftInBuffer = 0;
    private char[] buffer;
    private boolean lookahead = false;
    private int la;
    private int escapeCount = 0;

    public UnicodeDecodingReader(Reader in) {
        super(in);
    }

    public boolean markSupported() {
        return false;
    }

    public int read(char[] chars, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c < 0) {
                return i == 0 ? -1 : i;
            }
            chars[i + off] = (char)c;
        }
        return len;
    }

    public int read() throws IOException {
        int c;
        if (this.leftInBuffer > 0) {
            char c2 = this.buffer[this.buffer.length - this.leftInBuffer];
            --this.leftInBuffer;
            return c2;
        }
        if (this.lookahead) {
            this.lookahead = false;
            c = this.la;
        } else {
            c = super.read();
        }
        if (c == 92) {
            ++this.escapeCount;
            if (this.escapeCount % 2 == 1) {
                int la1 = super.read();
                this.lookahead = true;
                this.la = la1;
                if (la1 == 117) {
                    CharArrayWriter escapeSeq = new CharArrayWriter(6);
                    escapeSeq.write(117);
                    this.escapeCount = 0;
                    char[] hex = new char[4];
                    c = super.read();
                    while (c == 117) {
                        escapeSeq.write(117);
                        c = super.read();
                    }
                    int digits = 0;
                    if (c >= 0) {
                        do {
                            hex[digits++] = (char)c;
                        } while ((c = super.read()) >= 0 && digits < 4);
                    }
                    this.la = c;
                    escapeSeq.write(hex, 0, digits);
                    String hexStr = new String(hex, 0, digits);
                    if (digits == 4) {
                        try {
                            char translated = (char)Integer.parseInt(hexStr, 16);
                            if (translated >= '\u0003' && translated <= '\ufffe') {
                                if (Character.isDefined(translated)) {
                                    return translated;
                                }
                                this.log.verbose("No character defined for unicode escape '\\u" + hexStr + "'");
                            }
                        }
                        catch (NumberFormatException e) {
                            this.log.verbose("Malformed unicode escape '\\u" + hexStr + "'");
                        }
                    } else {
                        this.log.verbose("End of stream reached inside unicode escape");
                    }
                    this.buffer = escapeSeq.toCharArray();
                    this.leftInBuffer = this.buffer.length;
                    return 92;
                }
            }
        } else {
            this.escapeCount = 0;
        }
        return c;
    }
}

