/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.license;

import cenqua_com_licensing.atlassian.license.LicenseException;
import cenqua_com_licensing.atlassian.license.LicenseUtils;
import cenqua_com_licensing.atlassian.license.ng.LicenseManager;
import java.util.StringTokenizer;

public class LicensePair {
    public static final byte[] NEW_LICENSE_PREFIX = new byte[]{13, 14, 12, 10, 15};
    private final byte[] license;
    private final byte[] hash;
    private final String originalLicenseString;
    private final boolean isNG;

    public LicensePair(byte[] license, byte[] hash) throws LicenseException {
        this.license = license;
        this.hash = hash;
        this.isNG = this.startsWith(this.license, NEW_LICENSE_PREFIX);
        this.originalLicenseString = this.isNG ? LicenseManager.packNewLicense(this.license, this.hash) : LicensePair.packOldLicense(this.license, this.hash);
    }

    public LicensePair(byte[] text, byte[] hash, String originalString) {
        this.license = text;
        this.hash = hash;
        this.isNG = this.startsWith(this.license, NEW_LICENSE_PREFIX);
        this.originalLicenseString = originalString;
    }

    private boolean startsWith(byte[] target, byte[] prefix) {
        if (prefix.length > target.length) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.length; ++i2) {
            if (target[i2] == prefix[i2]) continue;
            return false;
        }
        return true;
    }

    public LicensePair(String license, String hash) throws LicenseException {
        if (license == null || hash == null) {
            throw new LicenseException("License string or hash are null.");
        }
        try {
            this.license = LicenseUtils.getBytes(license);
            this.hash = LicenseUtils.getBytes(hash);
            this.isNG = this.startsWith(this.license, NEW_LICENSE_PREFIX);
            this.originalLicenseString = this.isNG ? LicenseManager.packNewLicense(this.license, this.hash) : LicensePair.packOldLicense(this.license, this.hash);
        }
        catch (Exception e2) {
            throw new LicenseException("Exception generating license: " + e2);
        }
    }

    public LicensePair(String concatLicense) throws LicenseException {
        LicensePair pair = null;
        if (concatLicense == null) {
            throw new LicenseException("contactLicense was null");
        }
        LicensePair licensePair = LicenseManager.toLicensePair(concatLicense);
        pair = licensePair != null ? licensePair : LicensePair.decodeOldLicense(concatLicense);
        this.originalLicenseString = pair.originalLicenseString;
        this.hash = pair.hash;
        this.license = pair.license;
        this.isNG = pair.isNG;
    }

    private static LicensePair decodeOldLicense(String concatLicense) throws LicenseException {
        StringTokenizer tokenizer = new StringTokenizer(concatLicense, " \n\t\r");
        if (tokenizer.countTokens() < 3) {
            throw new LicenseException("License string is too short.");
        }
        try {
            byte[] hash = LicenseUtils.getBytes(tokenizer.nextToken() + tokenizer.nextToken());
            String licenseStr = "";
            while (tokenizer.hasMoreTokens()) {
                licenseStr = licenseStr + tokenizer.nextToken();
            }
            byte[] license = LicenseUtils.getBytes(licenseStr);
            return new LicensePair(license, hash, concatLicense);
        }
        catch (Exception e2) {
            throw new LicenseException("Exception generating license: " + e2);
        }
    }

    public boolean isNG() {
        return this.isNG;
    }

    public byte[] getLicense() {
        return this.license;
    }

    public String getLicenseString() {
        return LicenseUtils.getString(this.license);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getHashString() {
        return LicenseUtils.getString(this.hash);
    }

    public String getOriginalLicenseString() {
        return this.originalLicenseString;
    }

    public String toString() {
        return this.originalLicenseString;
    }

    public static String packOldLicense(byte[] license, byte[] hash) {
        StringBuffer sb = new StringBuffer();
        String hashString = LicenseUtils.getString(hash);
        int lineLength = hashString.length() / 2;
        while (hashString.length() > lineLength) {
            sb.append(hashString.substring(0, lineLength));
            sb.append("\n");
            hashString = hashString.substring(lineLength);
        }
        sb.append(hashString);
        sb.append("\n");
        String licenseStr = LicenseUtils.getString(license);
        while (licenseStr.length() > lineLength) {
            sb.append(licenseStr.substring(0, lineLength));
            sb.append("\n");
            licenseStr = licenseStr.substring(lineLength);
        }
        sb.append(licenseStr);
        sb.append("\n");
        return sb.toString();
    }
}

