/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.license.ng;

import cenqua_com_licensing.atlassian.license.LicenseException;
import cenqua_com_licensing.atlassian.license.ng.AtlassianLicense;
import cenqua_com_licensing.atlassian.license.ng.AtlassianProduct;
import cenqua_com_licensing.atlassian.time.DateTime;
import cenqua_com_licensing.atlassian.time.MutablePeriod;
import cenqua_com_licensing.atlassian.time.format.DateTimeFormatter;
import cenqua_com_licensing.atlassian.time.format.ISODateTimeFormat;
import cenqua_com_licensing.atlassian.time.format.ISOPeriodFormat;
import cenqua_com_licensing.atlassian.time.format.PeriodFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class AtlassianProductLicense
implements AtlassianLicense {
    private final Date creationDate;
    private final Date licenseExpiryDate;
    private final Date maintenanceExpiryDate;
    private final Date purchaseDate;
    private final String licenseID;
    private final String organisation;
    private final String serverID;
    private final int numberOfUsers;
    private final String contactName;
    private final String contactEmail;
    private final String licenseType;
    private final String partnerName;
    private final AtlassianProduct product;

    protected AtlassianProductLicense(Map data) throws LicenseException {
        this(data, null);
    }

    protected AtlassianProductLicense(Map data, AtlassianProduct product) throws LicenseException {
        this.product = product;
        if (!this.isActive(data)) {
            throw new LicenseException("The given license does not contain a valid license for product: " + product.getName());
        }
        String productNameSpace = product.getNameSpace();
        this.licenseID = (String)data.get("LicenseID");
        this.organisation = AtlassianProductLicense.getPropertyForNameSpace("Organisation", data, productNameSpace);
        this.licenseType = AtlassianProductLicense.getPropertyForNameSpace("LicenseType", data, productNameSpace);
        this.contactName = AtlassianProductLicense.getPropertyForNameSpace("ContactName", data, productNameSpace);
        this.contactEmail = AtlassianProductLicense.getPropertyForNameSpace("ContactEMail", data, productNameSpace);
        this.serverID = AtlassianProductLicense.getPropertyForNameSpace("ServerID", data, productNameSpace);
        this.numberOfUsers = AtlassianProductLicense.parseInt("NumberOfUsers", data, productNameSpace);
        this.creationDate = AtlassianProductLicense.parseDate("CreationDate", null, data, productNameSpace);
        this.purchaseDate = AtlassianProductLicense.parseDate("PurchaseDate", this.creationDate, data, productNameSpace);
        this.licenseExpiryDate = AtlassianProductLicense.parseDate("LicenseExpiryDate", null, data, productNameSpace);
        this.maintenanceExpiryDate = AtlassianProductLicense.parseDate("MaintenanceExpiryDate", null, data, productNameSpace);
        this.partnerName = AtlassianProductLicense.getPropertyForNameSpace("PartnerName", data, productNameSpace);
        if (this.creationDate == null) {
            throw new LicenseException("License creation date is missing in:\n" + data);
        }
    }

    protected boolean isActive(Map data) {
        return AtlassianProductLicense.isActive(data, this.product);
    }

    public static boolean isActive(Map data, AtlassianProduct product) {
        String activeStr = (String)data.get(product.getNameSpace() + "." + "active");
        return "true".equalsIgnoreCase(activeStr);
    }

    protected static String getPropertyForNameSpace(String propName, Map licenseData, String productNameSpace) {
        String val = null;
        if (productNameSpace != null && productNameSpace.length() > 0) {
            val = (String)licenseData.get(productNameSpace + "." + propName);
        }
        if (productNameSpace == null || productNameSpace.length() == 0 || val == null || val.length() == 0) {
            val = (String)licenseData.get(propName);
        }
        return val;
    }

    protected static int parseInt(String propName, Map licenseData, String productNameSpace) throws LicenseException {
        String str = AtlassianProductLicense.getPropertyForNameSpace(propName, licenseData, productNameSpace);
        if (str == null || str.length() == 0) {
            throw new LicenseException(propName + " property is missing in the license:\n" + licenseData);
        }
        if (str.equals("unlimited")) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    protected static Date parseDate(String propName, Date defaultValue, Map licenseData, String productNameSpace) throws LicenseException {
        String dateStr = AtlassianProductLicense.getPropertyForNameSpace(propName, licenseData, productNameSpace);
        if (dateStr == null || dateStr.length() == 0) {
            throw new LicenseException(propName + " property is missing in the license:\n" + licenseData);
        }
        if (dateStr.equals("unlimited")) {
            return defaultValue;
        }
        if (dateStr.startsWith("P")) {
            try {
                MutablePeriod period = new MutablePeriod();
                PeriodFormatter formatter = ISOPeriodFormat.standard();
                formatter.getParser().parseInto(period, dateStr, 0, Locale.ENGLISH);
                DateTime currentTime = new DateTime();
                DateTime targetTime = currentTime.plus(period);
                return targetTime.toDate();
            }
            catch (RuntimeException e2) {
                throw new LicenseException("Invalid date format: '" + dateStr + "'", e2);
            }
        }
        try {
            DateTimeFormatter parser = ISODateTimeFormat.dateOptionalTimeParser();
            DateTime targetTime = parser.parseDateTime(dateStr);
            return targetTime.toDate();
        }
        catch (RuntimeException e3) {
            throw new LicenseException("Invalid date format: '" + dateStr + "'", e3);
        }
    }

    public String getContactName() {
        return this.contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public Date getDateCreated() {
        return this.creationDate;
    }

    public Date getDatePurchased() {
        return this.purchaseDate;
    }

    public Date getExpiryDate() {
        return this.licenseExpiryDate;
    }

    public Date getMaintenanceExpiryDate() {
        return this.maintenanceExpiryDate;
    }

    public String getLicenseId() {
        return this.licenseID;
    }

    public String getServerId() {
        return this.serverID;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public boolean isExpired() {
        if (this.licenseExpiryDate == null) {
            return false;
        }
        return this.licenseExpiryDate.before(new Date());
    }

    public boolean isMaintenanceExpired() {
        if (this.maintenanceExpiryDate == null) {
            return false;
        }
        return this.maintenanceExpiryDate.before(new Date());
    }

    public int getNumberOfUsers() {
        return this.numberOfUsers;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public AtlassianProduct getProduct() {
        return this.product;
    }
}

