/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.time.tz;

import cenqua_com_licensing.atlassian.time.DateTimeZone;
import cenqua_com_licensing.atlassian.time.tz.DateTimeZoneBuilder;
import cenqua_com_licensing.atlassian.time.tz.Provider;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final String iResourcePath;
    private final ClassLoader iLoader;
    private final Map iZoneInfoMap;

    public ZoneInfoProvider(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!file.exists()) {
            throw new IOException("File directory doesn't exist: " + file);
        }
        if (!file.isDirectory()) {
            throw new IOException("File doesn't refer to a directory: " + file);
        }
        this.iFileDir = file;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public ZoneInfoProvider(String string) throws IOException {
        this(string, null, false);
    }

    public ZoneInfoProvider(String string, ClassLoader classLoader) throws IOException {
        this(string, classLoader, true);
    }

    private ZoneInfoProvider(String string, ClassLoader classLoader, boolean bl) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        this.iFileDir = null;
        this.iResourcePath = string;
        if (classLoader == null && !bl) {
            classLoader = this.getClass().getClassLoader();
        }
        this.iLoader = classLoader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public synchronized DateTimeZone getZone(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.iZoneInfoMap.get(string);
        if (v == null) {
            return null;
        }
        if (string.equals(v)) {
            return this.loadZoneData(string);
        }
        if (v instanceof SoftReference) {
            DateTimeZone dateTimeZone = (DateTimeZone)((SoftReference)v).get();
            if (dateTimeZone != null) {
                return dateTimeZone;
            }
            return this.loadZoneData(string);
        }
        return this.getZone((String)v);
    }

    public synchronized Set getAvailableIDs() {
        return Collections.unmodifiableSet(this.iZoneInfoMap.keySet());
    }

    protected void uncaughtException(Exception exception) {
        Thread thread = Thread.currentThread();
        thread.getThreadGroup().uncaughtException(thread, exception);
    }

    private InputStream openResource(String string) throws IOException {
        InputStream inputStream;
        if (this.iFileDir != null) {
            inputStream = new FileInputStream(new File(this.iFileDir, string));
        } else {
            String string2 = this.iResourcePath.concat(string);
            inputStream = this.iLoader != null ? this.iLoader.getResourceAsStream(string2) : ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                StringBuffer stringBuffer = new StringBuffer(40).append("Resource not found: \"").append(string2).append("\" ClassLoader: ").append(this.iLoader != null ? this.iLoader.toString() : "system");
                throw new IOException(stringBuffer.toString());
            }
        }
        return inputStream;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DateTimeZone loadZoneData(String var1_1) {
        var2_2 = null;
        try {
            try {
                var2_2 = this.openResource(var1_1);
                var3_3 = DateTimeZoneBuilder.readFrom(var2_2, var1_1);
                this.iZoneInfoMap.put(var1_1, new SoftReference<DateTimeZone>(var3_3));
                var4_5 = var3_3;
                var6_7 = null;
            }
            catch (IOException var3_4) {
                this.uncaughtException(var3_4);
                this.iZoneInfoMap.remove(var1_1);
                var4_6 = null;
                var6_8 = null;
                try {
                    if (var2_2 == null) return var4_6;
                    var2_2.close();
                    return var4_6;
                }
                catch (IOException var7_11) {
                    // empty catch block
                }
                return var4_6;
            }
        }
        catch (Throwable var5_13) {
            var6_9 = null;
            try {}
            catch (IOException var7_12) {
                throw var5_13;
            }
            if (var2_2 == null) throw var5_13;
            var2_2.close();
            throw var5_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 78->89)] { 
lbl37:
        // 1 sources

        if (var2_2 == null) return var4_5;
        var2_2.close();
        return var4_5;
lbl40:
        // 1 sources

        catch (IOException var7_10) {
            // empty catch block
        }
        return var4_5;
    }

    private static Map loadZoneInfoMap(InputStream inputStream) throws IOException {
        TreeMap<String, SoftReference<DateTimeZone>> treeMap = new TreeMap<String, SoftReference<DateTimeZone>>(String.CASE_INSENSITIVE_ORDER);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            ZoneInfoProvider.readZoneInfoMap(dataInputStream, treeMap);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {}
        treeMap.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return treeMap;
    }

    private static void readZoneInfoMap(DataInputStream dataInputStream, Map map) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = dataInputStream.readUTF().intern();
            ++n2;
        }
        n = dataInputStream.readUnsignedShort();
        int n3 = 0;
        while (n3 < n) {
            try {
                map.put(stringArray[dataInputStream.readUnsignedShort()], stringArray[dataInputStream.readUnsignedShort()]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Corrupt zone info map");
            }
            ++n3;
        }
    }
}

