/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.user.UserLogin;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="txTemplate")
public class TxTemplate {
    private ThreadLocal<Principal> user = new ThreadLocal();

    public void setEffectivePrincipal(Principal userLogin) {
        this.user.set(userLogin);
    }

    public Principal getEffectivePrincipal() {
        if (this.user.get() != null) {
            return this.user.get();
        }
        UserLogin p = AppConfig.getsConfig().getUserManager().getCurrentUser(CrucibleFilter.getRequest());
        return p != null ? p : Principal.Anonymous.ANON;
    }

    public UserLogin getEffectiveUserLogin() {
        if (this.getEffectivePrincipal() == Principal.Anonymous.ANON) {
            return null;
        }
        return (UserLogin)this.getEffectivePrincipal();
    }

    public <T> T execute(TxCallback<T> callback) {
        TxHelper txHelper = new TxHelper();
        TxStatus status = new TxStatus();
        try {
            T result;
            txHelper.beginTx();
            T t = result = callback.doInTransaction(status);
            return t;
        }
        catch (Exception e2) {
            status.setRollbackOnly();
            throw new RuntimeException(e2);
        }
        finally {
            if (!status.isRollbackOnly()) {
                txHelper.commitTx();
            }
            txHelper.rollbackTxIfNotCommited();
        }
    }

    private class TxStatus
    implements TransactionStatus {
        private boolean rollback = false;

        private TxStatus() {
        }

        public boolean isNewTransaction() {
            return true;
        }

        public boolean hasSavepoint() {
            return false;
        }

        public void setRollbackOnly() {
            this.rollback = true;
        }

        public boolean isRollbackOnly() {
            return this.rollback;
        }

        public boolean isCompleted() {
            return false;
        }

        public Object createSavepoint() throws TransactionException {
            return null;
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
        }
    }
}

