/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.configuration.metrics.XMLValidationException;
import com.cenqua.fisheye.util.StringUtil;
import java.util.List;
import org.apache.xmlbeans.XmlError;

public class EditCrucibleSettingsAction
extends BaseAction {
    private String xml;

    public String getMetrics() {
        if (StringUtil.nullOrEmpty(this.xml)) {
            return MetricsManager.INSTANCE.getConfigDef(MetricsManager.INSTANCE.getLatestVersion()).getXml();
        }
        return this.xml;
    }

    public Integer getMetricsVersion() {
        return MetricsManager.INSTANCE.getLatestVersion();
    }

    public void setMetrics(String xml) {
        this.xml = xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (!StringUtil.nullOrEmpty(this.xml)) {
            try {
                this.beginTx();
                Integer version = MetricsManager.INSTANCE.storeNewConfig(this.xml, false);
                if (version == -1) {
                    this.addActionMessage("Metrics config is identical to the current version.");
                } else {
                    this.addActionMessage("Saved metrics config as version " + version);
                }
                this.commitTx();
            }
            catch (XMLValidationException e2) {
                this.addActionError("There was a problem setting the metrics configuration:");
                List errors = e2.getErrors();
                for (XmlError error : errors) {
                    String errorMsg = error.getMessage();
                    if (error.getLine() != -1) {
                        errorMsg = errorMsg + " on line " + error.getLine();
                    }
                    if (error.getColumn() != -1) {
                        errorMsg = errorMsg + " column " + error.getColumn();
                    }
                    this.addActionError(errorMsg);
                }
            }
            finally {
                this.rollbackTxIfNotCommited();
            }
        }
        return "success";
    }
}

